/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager;

import java.util.BitSet;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.runtime.client.JobExecutionException;
import org.apache.flink.runtime.io.network.api.reader.RecordReader;
import org.apache.flink.runtime.io.network.api.writer.RecordWriter;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.testingUtils.TestingCluster;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.types.IntValue;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class SlotCountExceedingParallelismTest {
    private static final int NUMBER_OF_TMS = 2;
    private static final int NUMBER_OF_SLOTS_PER_TM = 2;
    private static final int PARALLELISM = 4;
    private static TestingCluster flink;

    @BeforeClass
    public static void setUp() throws Exception {
        flink = TestingUtils.startTestingCluster(2, 2, TestingUtils.DEFAULT_AKKA_ASK_TIMEOUT());
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (flink != null) {
            flink.stop();
        }
    }

    @Test
    public void testNoSlotSharingAndBlockingResult() throws Exception {
        String jobName = "SlotCountExceedingParallelismTest (no slot sharing, blocking results)";
        JobGraph jobGraph = this.createTestJobGraph("SlotCountExceedingParallelismTest (no slot sharing, blocking results)", 8, 4);
        this.submitJobGraphAndWait(jobGraph);
        jobGraph = this.createTestJobGraph("SlotCountExceedingParallelismTest (no slot sharing, blocking results)", 4, 8);
        this.submitJobGraphAndWait(jobGraph);
        jobGraph = this.createTestJobGraph("SlotCountExceedingParallelismTest (no slot sharing, blocking results)", 8, 8);
        this.submitJobGraphAndWait(jobGraph);
    }

    private void submitJobGraphAndWait(JobGraph jobGraph) throws JobExecutionException {
        flink.submitJobAndWait(jobGraph, false, TestingUtils.TESTING_DURATION());
    }

    private JobGraph createTestJobGraph(String jobName, int senderParallelism, int receiverParallelism) {
        JobVertex sender = new JobVertex("Sender");
        sender.setInvokableClass(RoundRobinSubtaskIndexSender.class);
        sender.getConfiguration().setInteger("number-of-times-to-send", receiverParallelism);
        sender.setParallelism(senderParallelism);
        JobVertex receiver = new JobVertex("Receiver");
        receiver.setInvokableClass(SubtaskIndexReceiver.class);
        receiver.getConfiguration().setInteger("number-of-indexes-to-receive", senderParallelism);
        receiver.setParallelism(receiverParallelism);
        receiver.connectNewDataSetAsInput(sender, DistributionPattern.ALL_TO_ALL, ResultPartitionType.BLOCKING);
        JobGraph jobGraph = new JobGraph(jobName, new JobVertex[]{sender, receiver});
        jobGraph.setAllowQueuedScheduling(true);
        return jobGraph;
    }

    public static class SubtaskIndexReceiver
    extends AbstractInvokable {
        public static final String CONFIG_KEY = "number-of-indexes-to-receive";

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invoke() throws Exception {
            RecordReader reader = new RecordReader(this.getEnvironment().getInputGate(0), IntValue.class, this.getEnvironment().getTaskManagerInfo().getTmpDirectories());
            try {
                IntValue record;
                int numberOfSubtaskIndexesToReceive = this.getTaskConfiguration().getInteger(CONFIG_KEY, 0);
                BitSet receivedSubtaskIndexes = new BitSet(numberOfSubtaskIndexesToReceive);
                int numberOfReceivedSubtaskIndexes = 0;
                while ((record = (IntValue)reader.next()) != null) {
                    if (++numberOfReceivedSubtaskIndexes > numberOfSubtaskIndexesToReceive) {
                        throw new IllegalStateException("Received more records than expected.");
                    }
                    int subtaskIndex = record.getValue();
                    if (receivedSubtaskIndexes.get(subtaskIndex)) {
                        throw new IllegalStateException("Received expected subtask index twice.");
                    }
                    receivedSubtaskIndexes.set(subtaskIndex, true);
                }
                if (receivedSubtaskIndexes.cardinality() != numberOfSubtaskIndexesToReceive) {
                    throw new IllegalStateException("Finished receive, but did not receive all expected subtask indexes.");
                }
            }
            finally {
                reader.clearBuffers();
            }
        }
    }

    public static class RoundRobinSubtaskIndexSender
    extends AbstractInvokable {
        public static final String CONFIG_KEY = "number-of-times-to-send";

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invoke() throws Exception {
            RecordWriter writer = new RecordWriter(this.getEnvironment().getWriter(0));
            int numberOfTimesToSend = this.getTaskConfiguration().getInteger(CONFIG_KEY, 0);
            IntValue subtaskIndex = new IntValue(this.getEnvironment().getTaskInfo().getIndexOfThisSubtask());
            try {
                for (int i = 0; i < numberOfTimesToSend; ++i) {
                    writer.emit((IOReadableWritable)subtaskIndex);
                }
                writer.flush();
            }
            finally {
                writer.clearBuffers();
            }
        }
    }
}

