/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph;

import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.flink.api.common.io.GenericInputFormat;
import org.apache.flink.api.common.io.InitializeOnMaster;
import org.apache.flink.api.common.operators.util.UserCodeObjectWrapper;
import org.apache.flink.api.common.operators.util.UserCodeWrapper;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.core.io.GenericInputSplit;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.InputFormatVertex;
import org.apache.flink.runtime.jobgraph.IntermediateDataSet;
import org.apache.flink.runtime.jobgraph.JobEdge;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.OutputFormatVertex;
import org.apache.flink.runtime.operators.util.TaskConfig;
import org.junit.Assert;
import org.junit.Test;

public class JobTaskVertexTest {
    @Test
    public void testConnectDirectly() {
        JobVertex source = new JobVertex("source");
        JobVertex target = new JobVertex("target");
        target.connectNewDataSetAsInput(source, DistributionPattern.POINTWISE);
        Assert.assertTrue((boolean)source.isInputVertex());
        Assert.assertFalse((boolean)source.isOutputVertex());
        Assert.assertFalse((boolean)target.isInputVertex());
        Assert.assertTrue((boolean)target.isOutputVertex());
        Assert.assertEquals((long)1L, (long)source.getNumberOfProducedIntermediateDataSets());
        Assert.assertEquals((long)1L, (long)target.getNumberOfInputs());
        Assert.assertEquals((Object)((JobEdge)target.getInputs().get(0)).getSource(), source.getProducedDataSets().get(0));
        Assert.assertEquals((long)1L, (long)((IntermediateDataSet)source.getProducedDataSets().get(0)).getConsumers().size());
        Assert.assertEquals((Object)target, (Object)((JobEdge)((IntermediateDataSet)source.getProducedDataSets().get(0)).getConsumers().get(0)).getTarget());
    }

    @Test
    public void testConnectMultipleTargets() {
        JobVertex source = new JobVertex("source");
        JobVertex target1 = new JobVertex("target1");
        JobVertex target2 = new JobVertex("target2");
        target1.connectNewDataSetAsInput(source, DistributionPattern.POINTWISE);
        target2.connectDataSetAsInput((IntermediateDataSet)source.getProducedDataSets().get(0), DistributionPattern.ALL_TO_ALL);
        Assert.assertTrue((boolean)source.isInputVertex());
        Assert.assertFalse((boolean)source.isOutputVertex());
        Assert.assertFalse((boolean)target1.isInputVertex());
        Assert.assertTrue((boolean)target1.isOutputVertex());
        Assert.assertFalse((boolean)target2.isInputVertex());
        Assert.assertTrue((boolean)target2.isOutputVertex());
        Assert.assertEquals((long)1L, (long)source.getNumberOfProducedIntermediateDataSets());
        Assert.assertEquals((long)2L, (long)((IntermediateDataSet)source.getProducedDataSets().get(0)).getConsumers().size());
        Assert.assertEquals((Object)((JobEdge)target1.getInputs().get(0)).getSource(), source.getProducedDataSets().get(0));
        Assert.assertEquals((Object)((JobEdge)target2.getInputs().get(0)).getSource(), source.getProducedDataSets().get(0));
    }

    @Test
    public void testOutputFormatVertex() {
        try {
            TestingOutputFormat outputFormat = new TestingOutputFormat();
            OutputFormatVertex of = new OutputFormatVertex("Name");
            new TaskConfig(of.getConfiguration()).setStubWrapper((UserCodeWrapper)new UserCodeObjectWrapper((Object)outputFormat));
            ClassLoader cl = this.getClass().getClassLoader();
            try {
                of.initializeOnMaster(cl);
                Assert.fail((String)"Did not throw expected exception.");
            }
            catch (TestException testException) {
                // empty catch block
            }
            OutputFormatVertex copy = (OutputFormatVertex)SerializationUtils.clone((Serializable)of);
            try {
                copy.initializeOnMaster(cl);
                Assert.fail((String)"Did not throw expected exception.");
            }
            catch (TestException testException) {}
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testInputFormatVertex() {
        try {
            TestInputFormat inputFormat = new TestInputFormat();
            InputFormatVertex vertex = new InputFormatVertex("Name");
            new TaskConfig(vertex.getConfiguration()).setStubWrapper((UserCodeWrapper)new UserCodeObjectWrapper((Object)inputFormat));
            ClassLoader cl = this.getClass().getClassLoader();
            vertex.initializeOnMaster(cl);
            InputSplit[] splits = vertex.getInputSplitSource().createInputSplits(77);
            Assert.assertNotNull((Object)splits);
            Assert.assertEquals((long)1L, (long)splits.length);
            Assert.assertEquals(TestSplit.class, splits[0].getClass());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testEagerlyDeployConsumers() throws Exception {
        JobVertex producer = new JobVertex("producer");
        JobVertex consumer = new JobVertex("consumer");
        JobEdge edge = consumer.connectNewDataSetAsInput(producer, DistributionPattern.ALL_TO_ALL);
        Assert.assertFalse((boolean)edge.getSource().getEagerlyDeployConsumers());
        consumer = new JobVertex("consumer");
        edge = consumer.connectNewDataSetAsInput(producer, DistributionPattern.ALL_TO_ALL, ResultPartitionType.PIPELINED);
        Assert.assertFalse((boolean)edge.getSource().getEagerlyDeployConsumers());
        consumer = new JobVertex("consumer");
        edge = consumer.connectNewDataSetAsInput(producer, DistributionPattern.ALL_TO_ALL, ResultPartitionType.PIPELINED, true);
        Assert.assertTrue((boolean)edge.getSource().getEagerlyDeployConsumers());
    }

    private static final class TestInputFormat
    extends GenericInputFormat<Object> {
        private TestInputFormat() {
        }

        public boolean reachedEnd() {
            return false;
        }

        public Object nextRecord(Object reuse) {
            return null;
        }

        public GenericInputSplit[] createInputSplits(int numSplits) throws IOException {
            return new GenericInputSplit[]{new TestSplit(0, 1)};
        }
    }

    private static final class TestSplit
    extends GenericInputSplit {
        public TestSplit(int partitionNumber, int totalNumberOfPartitions) {
            super(partitionNumber, totalNumberOfPartitions);
        }
    }

    private static final class TestException
    extends IOException {
        private TestException() {
        }
    }

    private static final class TestingOutputFormat
    extends DiscardingOutputFormat<Object>
    implements InitializeOnMaster {
        private TestingOutputFormat() {
        }

        public void initializeGlobal(int parallelism) throws IOException {
            throw new TestException();
        }
    }
}

