/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.util;

import java.util.Random;
import java.util.concurrent.Callable;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.network.api.serialization.EventSerializer;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.ResultSubpartition;
import org.apache.flink.runtime.io.network.partition.consumer.BufferOrEvent;
import org.apache.flink.runtime.io.network.util.TestProducerSource;
import org.apache.flink.util.Preconditions;

public class TestSubpartitionProducer
implements Callable<Boolean> {
    public static final int MAX_SLEEP_TIME_MS = 20;
    private final ResultSubpartition subpartition;
    private final boolean isSlowProducer;
    private final TestProducerSource source;
    private final Random random;

    public TestSubpartitionProducer(ResultSubpartition subpartition, boolean isSlowProducer, TestProducerSource source) {
        this.subpartition = (ResultSubpartition)Preconditions.checkNotNull((Object)subpartition);
        this.isSlowProducer = isSlowProducer;
        this.random = isSlowProducer ? new Random() : null;
        this.source = (TestProducerSource)Preconditions.checkNotNull((Object)source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean call() throws Exception {
        boolean success = false;
        try {
            BufferOrEvent bufferOrEvent;
            while ((bufferOrEvent = this.source.getNextBufferOrEvent()) != null) {
                if (bufferOrEvent.isBuffer()) {
                    this.subpartition.add(bufferOrEvent.getBuffer());
                } else if (bufferOrEvent.isEvent()) {
                    Buffer buffer = EventSerializer.toBuffer((AbstractEvent)bufferOrEvent.getEvent());
                    this.subpartition.add(buffer);
                } else {
                    throw new IllegalStateException("BufferOrEvent instance w/o buffer nor event.");
                }
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                if (!this.isSlowProducer) continue;
                Thread.sleep(this.random.nextInt(21));
            }
            this.subpartition.finish();
            success = true;
            Boolean bl = true;
            return bl;
        }
        finally {
            if (!success) {
                this.subpartition.release();
            }
        }
    }
}

