/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.util;

import java.util.Random;
import java.util.concurrent.Callable;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.network.api.EndOfPartitionEvent;
import org.apache.flink.runtime.io.network.api.serialization.EventSerializer;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.runtime.io.network.util.TestConsumerCallback;
import org.apache.flink.runtime.io.network.util.TestNotificationListener;
import org.apache.flink.runtime.util.event.NotificationListener;
import org.apache.flink.util.Preconditions;

public class TestSubpartitionConsumer
implements Callable<Boolean> {
    private static final int MAX_SLEEP_TIME_MS = 20;
    private final ResultSubpartitionView subpartitionView;
    private final boolean isSlowConsumer;
    private final TestConsumerCallback callback;
    private final Random random;

    public TestSubpartitionConsumer(ResultSubpartitionView subpartitionView, boolean isSlowConsumer, TestConsumerCallback callback) {
        this.subpartitionView = (ResultSubpartitionView)Preconditions.checkNotNull((Object)subpartitionView);
        this.isSlowConsumer = isSlowConsumer;
        this.random = isSlowConsumer ? new Random() : null;
        this.callback = (TestConsumerCallback)Preconditions.checkNotNull((Object)callback);
    }

    @Override
    public Boolean call() throws Exception {
        TestNotificationListener listener = new TestNotificationListener();
        try {
            while (true) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                Buffer buffer = this.subpartitionView.getNextBuffer();
                if (this.isSlowConsumer) {
                    Thread.sleep(this.random.nextInt(21));
                }
                if (buffer != null) {
                    if (buffer.isBuffer()) {
                        this.callback.onBuffer(buffer);
                        continue;
                    }
                    AbstractEvent event = EventSerializer.fromBuffer((Buffer)buffer, (ClassLoader)this.getClass().getClassLoader());
                    this.callback.onEvent(event);
                    buffer.recycle();
                    if (event.getClass() == EndOfPartitionEvent.class) {
                        this.subpartitionView.notifySubpartitionConsumed();
                        Boolean bl = true;
                        return bl;
                    }
                } else {
                    int current = listener.getNumberOfNotifications();
                    if (this.subpartitionView.registerListener((NotificationListener)listener)) {
                        listener.waitForNotification(current);
                        continue;
                    }
                    if (!this.subpartitionView.isReleased()) continue;
                    Boolean bl = true;
                    return bl;
                }
            }
        }
        finally {
            this.subpartitionView.releaseAllResources();
        }
    }
}

