/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.util;

import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferProvider;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.io.network.util.TestBufferFactory;
import org.apache.flink.runtime.util.event.EventListener;
import org.apache.flink.shaded.com.google.common.collect.Queues;
import org.apache.flink.util.Preconditions;

public class TestPooledBufferProvider
implements BufferProvider {
    private final Object bufferCreationLock = new Object();
    private final ArrayBlockingQueue<Buffer> buffers;
    private final TestBufferFactory bufferFactory;
    private final PooledBufferProviderRecycler bufferRecycler;
    private final int poolSize;

    public TestPooledBufferProvider(int poolSize) {
        Preconditions.checkArgument((poolSize > 0 ? 1 : 0) != 0);
        this.poolSize = poolSize;
        this.buffers = new ArrayBlockingQueue(poolSize);
        this.bufferRecycler = new PooledBufferProviderRecycler(this.buffers);
        this.bufferFactory = new TestBufferFactory(32768, this.bufferRecycler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Buffer requestBuffer() throws IOException {
        Buffer buffer = this.buffers.poll();
        if (buffer != null) {
            return buffer;
        }
        Object object = this.bufferCreationLock;
        synchronized (object) {
            if (this.bufferFactory.getNumberOfCreatedBuffers() < this.poolSize) {
                return this.bufferFactory.create();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Buffer requestBufferBlocking() throws IOException, InterruptedException {
        Buffer buffer = this.buffers.poll();
        if (buffer != null) {
            return buffer;
        }
        Object object = this.bufferCreationLock;
        synchronized (object) {
            if (this.bufferFactory.getNumberOfCreatedBuffers() < this.poolSize) {
                return this.bufferFactory.create();
            }
        }
        return this.buffers.take();
    }

    public boolean addListener(EventListener<Buffer> listener) {
        return this.bufferRecycler.registerListener(listener);
    }

    public boolean isDestroyed() {
        return false;
    }

    public int getMemorySegmentSize() {
        return this.bufferFactory.getBufferSize();
    }

    public int getNumberOfAvailableBuffers() {
        return this.buffers.size();
    }

    private static class PooledBufferProviderRecycler
    implements BufferRecycler {
        private final Object listenerRegistrationLock = new Object();
        private final Queue<Buffer> buffers;
        private final ConcurrentLinkedQueue<EventListener<Buffer>> registeredListeners = Queues.newConcurrentLinkedQueue();

        public PooledBufferProviderRecycler(Queue<Buffer> buffers) {
            this.buffers = buffers;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void recycle(MemorySegment segment) {
            Object object = this.listenerRegistrationLock;
            synchronized (object) {
                Buffer buffer = new Buffer(segment, (BufferRecycler)this);
                EventListener<Buffer> listener = this.registeredListeners.poll();
                if (listener == null) {
                    this.buffers.add(buffer);
                } else {
                    listener.onEvent((Object)buffer);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean registerListener(EventListener<Buffer> listener) {
            Object object = this.listenerRegistrationLock;
            synchronized (object) {
                if (this.buffers.isEmpty()) {
                    this.registeredListeners.add(listener);
                    return true;
                }
                return false;
            }
        }
    }
}

