/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.util;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.testutils.DiscardingRecycler;
import org.apache.flink.util.Preconditions;

public class TestBufferFactory {
    public static final int BUFFER_SIZE = 32768;
    private static final BufferRecycler RECYCLER = new DiscardingRecycler();
    private static final Buffer MOCK_BUFFER = TestBufferFactory.createBuffer();
    private final int bufferSize;
    private final BufferRecycler bufferRecycler;
    private AtomicInteger numberOfCreatedBuffers = new AtomicInteger();

    public TestBufferFactory() {
        this(32768, RECYCLER);
    }

    public TestBufferFactory(int bufferSize) {
        this(bufferSize, RECYCLER);
    }

    public TestBufferFactory(int bufferSize, BufferRecycler bufferRecycler) {
        Preconditions.checkArgument((bufferSize > 0 ? 1 : 0) != 0);
        this.bufferSize = bufferSize;
        this.bufferRecycler = (BufferRecycler)Preconditions.checkNotNull((Object)bufferRecycler);
    }

    public Buffer create() {
        this.numberOfCreatedBuffers.incrementAndGet();
        return new Buffer(MemorySegmentFactory.allocateUnpooledSegment((int)this.bufferSize), this.bufferRecycler);
    }

    public Buffer createFrom(MemorySegment segment) {
        return new Buffer(segment, this.bufferRecycler);
    }

    public int getNumberOfCreatedBuffers() {
        return this.numberOfCreatedBuffers.get();
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public static Buffer createBuffer() {
        return TestBufferFactory.createBuffer(32768);
    }

    public static Buffer createBuffer(int bufferSize) {
        Preconditions.checkArgument((bufferSize > 0 ? 1 : 0) != 0);
        return new Buffer(MemorySegmentFactory.allocateUnpooledSegment((int)bufferSize), RECYCLER);
    }

    public static Buffer getMockBuffer() {
        return MOCK_BUFFER;
    }
}

