/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.netty.PartitionStateChecker;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.apache.flink.runtime.io.network.partition.consumer.TestInputChannel;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.metrics.groups.IOMetricGroup;
import org.apache.flink.runtime.operators.testutils.UnregisteredTaskMetricsGroup;
import org.apache.flink.runtime.util.event.EventListener;
import org.apache.flink.util.Preconditions;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestSingleInputGate {
    protected final SingleInputGate inputGate;
    protected final TestInputChannel[] inputChannels;

    public TestSingleInputGate(int numberOfInputChannels) {
        this(numberOfInputChannels, true);
    }

    public TestSingleInputGate(int numberOfInputChannels, boolean initialize) {
        Preconditions.checkArgument((numberOfInputChannels >= 1 ? 1 : 0) != 0);
        SingleInputGate realGate = new SingleInputGate("Test Task Name", new JobID(), new ExecutionAttemptID(), new IntermediateDataSetID(), 0, numberOfInputChannels, (PartitionStateChecker)Mockito.mock(PartitionStateChecker.class), (IOMetricGroup)new UnregisteredTaskMetricsGroup.DummyIOMetricGroup());
        this.inputGate = (SingleInputGate)Mockito.spy((Object)realGate);
        try {
            Field f = realGate.getClass().getDeclaredField("inputChannelsWithData");
            f.setAccessible(true);
            final BlockingQueue notifications = (BlockingQueue)f.get(realGate);
            ((SingleInputGate)Mockito.doAnswer((Answer)new Answer<Void>(){

                public Void answer(InvocationOnMock invocation) throws Throwable {
                    invocation.callRealMethod();
                    if (!notifications.isEmpty()) {
                        EventListener listener = (EventListener)invocation.getArguments()[0];
                        listener.onEvent((Object)TestSingleInputGate.this.inputGate);
                    }
                    return null;
                }
            }).when((Object)this.inputGate)).registerListener((EventListener)Matchers.any(EventListener.class));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.inputChannels = new TestInputChannel[numberOfInputChannels];
        if (initialize) {
            for (int i = 0; i < numberOfInputChannels; ++i) {
                this.inputChannels[i] = new TestInputChannel(this.inputGate, i);
                this.inputGate.setInputChannel(new IntermediateResultPartitionID(), this.inputChannels[i].getInputChannel());
            }
        }
    }

    public TestSingleInputGate read(Buffer buffer, int channelIndex) throws IOException, InterruptedException {
        Preconditions.checkElementIndex((int)channelIndex, (int)this.inputGate.getNumberOfInputChannels());
        this.inputChannels[channelIndex].read(buffer);
        return this;
    }

    public TestSingleInputGate readBuffer() throws IOException, InterruptedException {
        return this.readBuffer(0);
    }

    public TestSingleInputGate readBuffer(int channelIndex) throws IOException, InterruptedException {
        this.inputChannels[channelIndex].readBuffer();
        return this;
    }

    public TestSingleInputGate readEvent() throws IOException, InterruptedException {
        return this.readEvent(0);
    }

    public TestSingleInputGate readEvent(int channelIndex) throws IOException, InterruptedException {
        this.inputChannels[channelIndex].readEvent();
        return this;
    }

    public TestSingleInputGate readEndOfSuperstepEvent() throws IOException, InterruptedException {
        for (TestInputChannel inputChannel : this.inputChannels) {
            inputChannel.readEndOfSuperstepEvent();
        }
        return this;
    }

    public TestSingleInputGate readEndOfSuperstepEvent(int channelIndex) throws IOException, InterruptedException {
        this.inputChannels[channelIndex].readEndOfSuperstepEvent();
        return this;
    }

    public TestSingleInputGate readEndOfPartitionEvent() throws IOException, InterruptedException {
        for (TestInputChannel inputChannel : this.inputChannels) {
            inputChannel.readEndOfPartitionEvent();
        }
        return this;
    }

    public TestSingleInputGate readEndOfPartitionEvent(int channelIndex) throws IOException, InterruptedException {
        this.inputChannels[channelIndex].readEndOfPartitionEvent();
        return this;
    }

    public SingleInputGate getInputGate() {
        return this.inputGate;
    }

    public List<Integer> readAllChannels() throws IOException, InterruptedException {
        ArrayList<Integer> readOrder = new ArrayList<Integer>(this.inputChannels.length);
        for (int i = 0; i < this.inputChannels.length; ++i) {
            readOrder.add(i);
        }
        Collections.shuffle(readOrder);
        Iterator iterator = readOrder.iterator();
        while (iterator.hasNext()) {
            int channelIndex = (Integer)iterator.next();
            this.inputChannels[channelIndex].readBuffer();
        }
        return readOrder;
    }
}

