/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import java.io.IOException;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.network.api.EndOfPartitionEvent;
import org.apache.flink.runtime.io.network.api.EndOfSuperstepEvent;
import org.apache.flink.runtime.io.network.api.serialization.EventSerializer;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.apache.flink.runtime.io.network.util.TestTaskEvent;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.util.Preconditions;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.OngoingStubbing;

public class TestInputChannel {
    private final InputChannel mock = (InputChannel)Mockito.mock(InputChannel.class);
    private final SingleInputGate inputGate;
    protected OngoingStubbing<Buffer> stubbing;

    public TestInputChannel(SingleInputGate inputGate, int channelIndex) {
        Preconditions.checkArgument((channelIndex >= 0 ? 1 : 0) != 0);
        this.inputGate = (SingleInputGate)Preconditions.checkNotNull((Object)inputGate);
        Mockito.when((Object)this.mock.getChannelIndex()).thenReturn((Object)channelIndex);
    }

    public TestInputChannel read(Buffer buffer) throws IOException, InterruptedException {
        this.stubbing = this.stubbing == null ? Mockito.when((Object)this.mock.getNextBuffer()).thenReturn((Object)buffer) : this.stubbing.thenReturn((Object)buffer);
        this.inputGate.onAvailableBuffer(this.mock);
        return this;
    }

    public TestInputChannel readBuffer() throws IOException, InterruptedException {
        Buffer buffer = (Buffer)Mockito.mock(Buffer.class);
        Mockito.when((Object)buffer.isBuffer()).thenReturn((Object)true);
        return this.read(buffer);
    }

    public TestInputChannel readEvent() throws IOException, InterruptedException {
        return this.read(EventSerializer.toBuffer((AbstractEvent)new TestTaskEvent()));
    }

    public TestInputChannel readEndOfSuperstepEvent() throws IOException, InterruptedException {
        return this.read(EventSerializer.toBuffer((AbstractEvent)EndOfSuperstepEvent.INSTANCE));
    }

    public TestInputChannel readEndOfPartitionEvent() throws IOException, InterruptedException {
        Answer<Buffer> answer = new Answer<Buffer>(){

            public Buffer answer(InvocationOnMock invocationOnMock) throws Throwable {
                Mockito.when((Object)TestInputChannel.this.mock.isReleased()).thenReturn((Object)true);
                return EventSerializer.toBuffer((AbstractEvent)EndOfPartitionEvent.INSTANCE);
            }
        };
        this.stubbing = this.stubbing == null ? Mockito.when((Object)this.mock.getNextBuffer()).thenAnswer((Answer)answer) : this.stubbing.thenAnswer((Answer)answer);
        this.inputGate.onAvailableBuffer(this.mock);
        return this;
    }

    public InputChannel getInputChannel() {
        return this.mock;
    }

    public static TestInputChannel[] createInputChannels(SingleInputGate inputGate, int numberOfInputChannels) {
        Preconditions.checkNotNull((Object)inputGate);
        Preconditions.checkArgument((numberOfInputChannels > 0 ? 1 : 0) != 0);
        TestInputChannel[] mocks = new TestInputChannel[numberOfInputChannels];
        for (int i = 0; i < numberOfInputChannels; ++i) {
            mocks[i] = new TestInputChannel(inputGate, i);
            inputGate.setInputChannel(new IntermediateResultPartitionID(), mocks[i].getInputChannel());
        }
        return mocks;
    }
}

