/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import org.apache.flink.runtime.io.disk.iomanager.BufferFileWriter;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.io.network.partition.ResultSubpartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.runtime.io.network.partition.SpilledSubpartitionViewSyncIO;
import org.apache.flink.runtime.io.network.partition.SpilledSubpartitionViewTest;
import org.apache.flink.runtime.io.network.util.TestConsumerCallback;
import org.apache.flink.runtime.io.network.util.TestInfiniteBufferProvider;
import org.apache.flink.runtime.io.network.util.TestPooledBufferProvider;
import org.apache.flink.runtime.io.network.util.TestSubpartitionConsumer;
import org.junit.AfterClass;
import org.junit.Test;
import org.mockito.Mockito;

public class SpilledSubpartitionViewSyncIOTest {
    private static final IOManager ioManager = new IOManagerAsync();
    private static final TestInfiniteBufferProvider writerBufferPool = new TestInfiniteBufferProvider();

    @AfterClass
    public static void shutdown() {
        ioManager.shutdown();
    }

    @Test
    public void testWriteConsume() throws Exception {
        int numberOfBuffersToWrite = 512;
        BufferFileWriter writer = SpilledSubpartitionViewTest.createWriterAndWriteBuffers(ioManager, writerBufferPool, 512);
        writer.close();
        TestPooledBufferProvider viewBufferPool = new TestPooledBufferProvider(1);
        SpilledSubpartitionViewSyncIO view = new SpilledSubpartitionViewSyncIO((ResultSubpartition)Mockito.mock(ResultSubpartition.class), viewBufferPool.getMemorySegmentSize(), writer.getChannelID(), 0L);
        TestSubpartitionConsumer consumer = new TestSubpartitionConsumer((ResultSubpartitionView)view, false, new TestConsumerCallback.RecyclingCallback());
        consumer.call();
    }

    @Test
    public void testConsumeWithFewBuffers() throws Exception {
        int numberOfBuffersToWrite = 512;
        BufferFileWriter writer = SpilledSubpartitionViewTest.createWriterAndWriteBuffers(ioManager, writerBufferPool, 512);
        writer.close();
        SpilledSubpartitionViewSyncIO view = new SpilledSubpartitionViewSyncIO((ResultSubpartition)Mockito.mock(ResultSubpartition.class), 32768, writer.getChannelID(), 0L);
        TestSubpartitionConsumer consumer = new TestSubpartitionConsumer((ResultSubpartitionView)view, false, new TestConsumerCallback.RecyclingCallback());
        consumer.call();
    }
}

