/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.buffer;

import org.apache.flink.core.memory.MemoryType;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.buffer.NetworkBufferPool;
import org.junit.Assert;
import org.junit.Test;

public class NetworkBufferPoolTest {
    @Test
    public void testCreatePoolAfterDestroy() {
        try {
            int bufferSize = 128;
            int numBuffers = 10;
            NetworkBufferPool globalPool = new NetworkBufferPool(10, 128, MemoryType.HEAP);
            Assert.assertEquals((long)128L, (long)globalPool.getMemorySegmentSize());
            Assert.assertEquals((long)10L, (long)globalPool.getTotalNumberOfMemorySegments());
            Assert.assertEquals((long)10L, (long)globalPool.getNumberOfAvailableMemorySegments());
            Assert.assertEquals((long)0L, (long)globalPool.getNumberOfRegisteredBufferPools());
            globalPool.destroy();
            Assert.assertTrue((boolean)globalPool.isDestroyed());
            try {
                globalPool.createBufferPool(2, true);
                Assert.fail((String)"Should throw an IllegalStateException");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            try {
                globalPool.createBufferPool(2, false);
                Assert.fail((String)"Should throw an IllegalStateException");
            }
            catch (IllegalStateException illegalStateException) {}
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDestroyAll() {
        try {
            Buffer[] buffers;
            NetworkBufferPool globalPool = new NetworkBufferPool(10, 128, MemoryType.HEAP);
            BufferPool fixedPool = globalPool.createBufferPool(2, true);
            BufferPool nonFixedPool = globalPool.createBufferPool(5, false);
            Assert.assertEquals((long)2L, (long)fixedPool.getNumberOfRequiredMemorySegments());
            Assert.assertEquals((long)5L, (long)nonFixedPool.getNumberOfRequiredMemorySegments());
            for (Buffer b : buffers = new Buffer[]{fixedPool.requestBuffer(), fixedPool.requestBuffer(), nonFixedPool.requestBuffer(), nonFixedPool.requestBuffer(), nonFixedPool.requestBuffer(), nonFixedPool.requestBuffer(), nonFixedPool.requestBuffer(), nonFixedPool.requestBuffer(), nonFixedPool.requestBuffer(), nonFixedPool.requestBuffer()}) {
                Assert.assertNotNull((Object)b);
                Assert.assertNotNull((Object)b.getMemorySegment());
            }
            Assert.assertNull((Object)fixedPool.requestBuffer());
            Assert.assertNull((Object)nonFixedPool.requestBuffer());
            globalPool.destroyAllBufferPools();
            Assert.assertFalse((boolean)globalPool.isDestroyed());
            Assert.assertTrue((boolean)fixedPool.isDestroyed());
            Assert.assertTrue((boolean)nonFixedPool.isDestroyed());
            Assert.assertEquals((long)0L, (long)globalPool.getNumberOfRegisteredBufferPools());
            Assert.assertEquals((long)0L, (long)globalPool.getNumberOfAvailableMemorySegments());
            for (Buffer b : buffers) {
                b.recycle();
            }
            Assert.assertEquals((long)globalPool.getTotalNumberOfMemorySegments(), (long)globalPool.getNumberOfAvailableMemorySegments());
            try {
                fixedPool.requestBuffer();
                Assert.fail((String)"Should fail with an IllegalStateException");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            try {
                nonFixedPool.requestBuffer();
                Assert.fail((String)"Should fail with an IllegalStateException");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            Assert.assertNotNull((Object)globalPool.createBufferPool(10, false));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

