/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.buffer;

import java.nio.ByteBuffer;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class BufferTest {
    @Test
    public void testSetGetSize() {
        MemorySegment segment = MemorySegmentFactory.allocateUnpooledSegment((int)1024);
        BufferRecycler recycler = (BufferRecycler)Mockito.mock(BufferRecycler.class);
        Buffer buffer = new Buffer(segment, recycler);
        Assert.assertEquals((long)segment.size(), (long)buffer.getSize());
        buffer.setSize(segment.size() / 2);
        Assert.assertEquals((long)(segment.size() / 2), (long)buffer.getSize());
        try {
            buffer.setSize(-1);
            Assert.fail((String)"Didn't throw expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            buffer.setSize(segment.size() + 1);
            Assert.fail((String)"Didn't throw expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testgetNioBufferThreadSafe() {
        MemorySegment segment = MemorySegmentFactory.allocateUnpooledSegment((int)1024);
        BufferRecycler recycler = (BufferRecycler)Mockito.mock(BufferRecycler.class);
        Buffer buffer = new Buffer(segment, recycler);
        ByteBuffer buf1 = buffer.getNioBuffer();
        ByteBuffer buf2 = buffer.getNioBuffer();
        Assert.assertNotNull((Object)buf1);
        Assert.assertNotNull((Object)buf2);
        Assert.assertTrue((String)"Repeated call to getNioBuffer() returns the same nio buffer", (buf1 != buf2 ? 1 : 0) != 0);
    }
}

