/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.buffer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import org.apache.flink.core.memory.MemoryType;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.buffer.NetworkBufferPool;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BufferPoolFactoryTest {
    private static final int numBuffers = 1024;
    private static final int memorySegmentSize = 128;
    private NetworkBufferPool networkBufferPool;

    @Before
    public void setupNetworkBufferPool() {
        this.networkBufferPool = new NetworkBufferPool(1024, 128, MemoryType.HEAP);
    }

    @After
    public void verifyAllBuffersReturned() {
        String msg = "Did not return all buffers to network buffer pool after test.";
        Assert.assertEquals((String)msg, (long)1024L, (long)this.networkBufferPool.getNumberOfAvailableMemorySegments());
    }

    @Test(expected=IOException.class)
    public void testRequireMoreThanPossible() throws IOException {
        this.networkBufferPool.createBufferPool(this.networkBufferPool.getTotalNumberOfMemorySegments() * 2, false);
    }

    @Test
    public void testFixedPool() throws IOException {
        BufferPool lbp = this.networkBufferPool.createBufferPool(1, true);
        Assert.assertEquals((long)1L, (long)lbp.getNumBuffers());
    }

    @Test
    public void testSingleManagedPoolGetsAll() throws IOException {
        BufferPool lbp = this.networkBufferPool.createBufferPool(1, false);
        Assert.assertEquals((long)this.networkBufferPool.getTotalNumberOfMemorySegments(), (long)lbp.getNumBuffers());
    }

    @Test
    public void testSingleManagedPoolGetsAllExceptFixedOnes() throws IOException {
        BufferPool fixed = this.networkBufferPool.createBufferPool(24, true);
        BufferPool lbp = this.networkBufferPool.createBufferPool(1, false);
        Assert.assertEquals((long)24L, (long)fixed.getNumBuffers());
        Assert.assertEquals((long)(this.networkBufferPool.getTotalNumberOfMemorySegments() - fixed.getNumBuffers()), (long)lbp.getNumBuffers());
    }

    @Test
    public void testUniformDistribution() throws IOException {
        BufferPool first = this.networkBufferPool.createBufferPool(0, false);
        BufferPool second = this.networkBufferPool.createBufferPool(0, false);
        Assert.assertEquals((long)(this.networkBufferPool.getTotalNumberOfMemorySegments() / 2), (long)first.getNumBuffers());
        Assert.assertEquals((long)(this.networkBufferPool.getTotalNumberOfMemorySegments() / 2), (long)second.getNumBuffers());
    }

    @Test
    public void testAllDistributed() {
        Random random = new Random();
        try {
            ArrayList<BufferPool> pools = new ArrayList<BufferPool>();
            int numPools = 32;
            for (int i = 0; i < numPools; ++i) {
                pools.add(this.networkBufferPool.createBufferPool(random.nextInt(8), random.nextBoolean()));
            }
            int numDistributedBuffers = 0;
            for (BufferPool pool : pools) {
                numDistributedBuffers += pool.getNumBuffers();
            }
            Assert.assertEquals((long)1024L, (long)numDistributedBuffers);
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)t.getMessage());
        }
    }

    @Test
    public void testCreateDestroy() throws IOException {
        BufferPool first = this.networkBufferPool.createBufferPool(0, false);
        Assert.assertEquals((long)this.networkBufferPool.getTotalNumberOfMemorySegments(), (long)first.getNumBuffers());
        BufferPool second = this.networkBufferPool.createBufferPool(0, false);
        Assert.assertEquals((long)(this.networkBufferPool.getTotalNumberOfMemorySegments() / 2), (long)first.getNumBuffers());
        Assert.assertEquals((long)(this.networkBufferPool.getTotalNumberOfMemorySegments() / 2), (long)second.getNumBuffers());
        first.lazyDestroy();
        Assert.assertEquals((long)this.networkBufferPool.getTotalNumberOfMemorySegments(), (long)second.getNumBuffers());
    }
}

