/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.serialization.types;

import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.io.network.api.serialization.types.SerializationTestType;

public class ByteSubArrayType
implements SerializationTestType {
    private static final int MAX_LEN = 512;
    private final byte[] data = new byte[512];
    private int len = 0;

    @Override
    public ByteSubArrayType getRandom(Random rnd) {
        int len = rnd.nextInt(512) + 1;
        ByteSubArrayType t = new ByteSubArrayType();
        t.len = len;
        byte[] data = t.data;
        for (int i = 0; i < len; ++i) {
            data[i] = (byte)rnd.nextInt(256);
        }
        return t;
    }

    @Override
    public int length() {
        return this.len + 4;
    }

    public void write(DataOutputView out) throws IOException {
        out.writeInt(this.len);
        out.write(this.data, 0, this.len);
    }

    public void read(DataInputView in) throws IOException {
        this.len = in.readInt();
        in.readFully(this.data, 0, this.len);
    }

    public int hashCode() {
        byte[] copy = new byte[this.len];
        System.arraycopy(this.data, 0, copy, 0, this.len);
        return Arrays.hashCode(copy);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ByteSubArrayType) {
            ByteSubArrayType other = (ByteSubArrayType)obj;
            if (this.len == other.len) {
                for (int i = 0; i < this.len; ++i) {
                    if (this.data[i] == other.data[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

