/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.serialization;

import java.io.IOException;
import java.util.Random;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.io.network.api.serialization.RecordSerializer;
import org.apache.flink.runtime.io.network.api.serialization.SpanningRecordSerializer;
import org.apache.flink.runtime.io.network.api.serialization.types.SerializationTestType;
import org.apache.flink.runtime.io.network.api.serialization.types.SerializationTestTypeFactory;
import org.apache.flink.runtime.io.network.api.serialization.types.Util;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class SpanningRecordSerializerTest {
    @Test
    public void testHasData() {
        int SEGMENT_SIZE = 16;
        SpanningRecordSerializer serializer = new SpanningRecordSerializer();
        Buffer buffer = new Buffer(MemorySegmentFactory.allocateUnpooledSegment((int)16), (BufferRecycler)Mockito.mock(BufferRecycler.class));
        SerializationTestType randomIntRecord = Util.randomRecord(SerializationTestTypeFactory.INT);
        Assert.assertFalse((boolean)serializer.hasData());
        try {
            serializer.addRecord((IOReadableWritable)randomIntRecord);
            Assert.assertTrue((boolean)serializer.hasData());
            serializer.setNextBuffer(buffer);
            Assert.assertTrue((boolean)serializer.hasData());
            serializer.clear();
            Assert.assertFalse((boolean)serializer.hasData());
            serializer.setNextBuffer(buffer);
            serializer.addRecord((IOReadableWritable)randomIntRecord);
            Assert.assertTrue((boolean)serializer.hasData());
            serializer.addRecord((IOReadableWritable)randomIntRecord);
            Assert.assertTrue((boolean)serializer.hasData());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testEmptyRecords() {
        int SEGMENT_SIZE = 11;
        SpanningRecordSerializer serializer = new SpanningRecordSerializer();
        Buffer buffer = new Buffer(MemorySegmentFactory.allocateUnpooledSegment((int)11), (BufferRecycler)Mockito.mock(BufferRecycler.class));
        try {
            Assert.assertEquals((Object)RecordSerializer.SerializationResult.FULL_RECORD, (Object)serializer.setNextBuffer(buffer));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            SerializationTestType emptyRecord = new SerializationTestType(){

                @Override
                public SerializationTestType getRandom(Random rnd) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public int length() {
                    throw new UnsupportedOperationException();
                }

                public void write(DataOutputView out) {
                }

                public void read(DataInputView in) {
                }

                public int hashCode() {
                    throw new UnsupportedOperationException();
                }

                public boolean equals(Object obj) {
                    throw new UnsupportedOperationException();
                }
            };
            RecordSerializer.SerializationResult result = serializer.addRecord((IOReadableWritable)emptyRecord);
            Assert.assertEquals((Object)RecordSerializer.SerializationResult.FULL_RECORD, (Object)result);
            result = serializer.addRecord((IOReadableWritable)emptyRecord);
            Assert.assertEquals((Object)RecordSerializer.SerializationResult.FULL_RECORD, (Object)result);
            result = serializer.addRecord((IOReadableWritable)emptyRecord);
            Assert.assertEquals((Object)RecordSerializer.SerializationResult.PARTIAL_RECORD_MEMORY_SEGMENT_FULL, (Object)result);
            result = serializer.setNextBuffer(buffer);
            Assert.assertEquals((Object)RecordSerializer.SerializationResult.FULL_RECORD, (Object)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testIntRecordsSpanningMultipleSegments() {
        boolean SEGMENT_SIZE = true;
        int NUM_VALUES = 10;
        try {
            this.test(Util.randomRecords(10, SerializationTestTypeFactory.INT), 1);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Test encountered an unexpected exception.");
        }
    }

    @Test
    public void testIntRecordsWithAlignedSegments() {
        int SEGMENT_SIZE = 64;
        int NUM_VALUES = 64;
        try {
            this.test(Util.randomRecords(64, SerializationTestTypeFactory.INT), 64);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Test encountered an unexpected exception.");
        }
    }

    @Test
    public void testIntRecordsWithUnalignedSegments() {
        int SEGMENT_SIZE = 31;
        int NUM_VALUES = 248;
        try {
            this.test(Util.randomRecords(248, SerializationTestTypeFactory.INT), 31);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Test encountered an unexpected exception.");
        }
    }

    @Test
    public void testRandomRecords() {
        int SEGMENT_SIZE = 127;
        int NUM_VALUES = 100000;
        try {
            this.test(Util.randomRecords(100000), 127);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Test encountered an unexpected exception.");
        }
    }

    private void test(Util.MockRecords records, int segmentSize) throws Exception {
        int SERIALIZATION_OVERHEAD = 4;
        SpanningRecordSerializer serializer = new SpanningRecordSerializer();
        Buffer buffer = new Buffer(MemorySegmentFactory.allocateUnpooledSegment((int)segmentSize), (BufferRecycler)Mockito.mock(BufferRecycler.class));
        serializer.setNextBuffer(buffer);
        int numBytes = 0;
        for (SerializationTestType record : records) {
            RecordSerializer.SerializationResult result = serializer.addRecord((IOReadableWritable)record);
            if ((numBytes += record.length() + 4) < segmentSize) {
                Assert.assertEquals((Object)RecordSerializer.SerializationResult.FULL_RECORD, (Object)result);
                continue;
            }
            if (numBytes == segmentSize) {
                Assert.assertEquals((Object)RecordSerializer.SerializationResult.FULL_RECORD_MEMORY_SEGMENT_FULL, (Object)result);
                serializer.setNextBuffer(buffer);
                numBytes = 0;
                continue;
            }
            Assert.assertEquals((Object)RecordSerializer.SerializationResult.PARTIAL_RECORD_MEMORY_SEGMENT_FULL, (Object)result);
            while (result.isFullBuffer()) {
                numBytes -= segmentSize;
                result = serializer.setNextBuffer(buffer);
            }
        }
    }
}

