/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.instance;

import akka.actor.ActorSystem;
import akka.testkit.JavaTestKit;
import com.typesafe.config.Config;
import java.net.InetAddress;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.UUID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.instance.HardwareDescription;
import org.apache.flink.runtime.instance.Instance;
import org.apache.flink.runtime.instance.InstanceConnectionInfo;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.instance.InstanceManager;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.runtime.testutils.CommonTestUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class InstanceManagerTest {
    static ActorSystem system;
    static UUID leaderSessionID;

    @BeforeClass
    public static void setup() {
        system = ActorSystem.create((String)"TestingActorSystem", (Config)TestingUtils.testConfig());
    }

    @AfterClass
    public static void teardown() {
        JavaTestKit.shutdownActorSystem((ActorSystem)system);
        system = null;
    }

    @Test
    public void testInstanceRegistering() {
        try {
            InstanceManager cm = new InstanceManager();
            int dataPort = 20000;
            HardwareDescription hardwareDescription = HardwareDescription.extractFromSystem((long)4096L);
            InetAddress address = InetAddress.getByName("127.0.0.1");
            InstanceConnectionInfo ici1 = new InstanceConnectionInfo(address, 20000);
            InstanceConnectionInfo ici2 = new InstanceConnectionInfo(address, 20015);
            InstanceConnectionInfo ici3 = new InstanceConnectionInfo(address, 20030);
            ResourceID resID1 = ResourceID.generate();
            ResourceID resID2 = ResourceID.generate();
            ResourceID resID3 = ResourceID.generate();
            JavaTestKit probe1 = new JavaTestKit(system);
            JavaTestKit probe2 = new JavaTestKit(system);
            JavaTestKit probe3 = new JavaTestKit(system);
            cm.registerTaskManager(probe1.getRef(), resID1, ici1, hardwareDescription, 1, leaderSessionID);
            cm.registerTaskManager(probe2.getRef(), resID2, ici2, hardwareDescription, 2, leaderSessionID);
            cm.registerTaskManager(probe3.getRef(), resID3, ici3, hardwareDescription, 5, leaderSessionID);
            Assert.assertEquals((long)3L, (long)cm.getNumberOfRegisteredTaskManagers());
            Assert.assertEquals((long)8L, (long)cm.getTotalNumberOfSlots());
            Collection instances = cm.getAllRegisteredInstances();
            HashSet<InstanceConnectionInfo> instanceConnectionInfos = new HashSet<InstanceConnectionInfo>();
            for (Instance instance : instances) {
                instanceConnectionInfos.add(instance.getInstanceConnectionInfo());
            }
            Assert.assertTrue((boolean)instanceConnectionInfos.contains(ici1));
            Assert.assertTrue((boolean)instanceConnectionInfos.contains(ici2));
            Assert.assertTrue((boolean)instanceConnectionInfos.contains(ici3));
            cm.shutdown();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Test erroneous: " + e.getMessage()));
        }
    }

    @Test
    public void testRegisteringAlreadyRegistered() {
        try {
            InstanceManager cm = new InstanceManager();
            int dataPort = 20000;
            ResourceID resID1 = ResourceID.generate();
            ResourceID resID2 = ResourceID.generate();
            HardwareDescription resources = HardwareDescription.extractFromSystem((long)4096L);
            InetAddress address = InetAddress.getByName("127.0.0.1");
            InstanceConnectionInfo ici = new InstanceConnectionInfo(address, 20000);
            JavaTestKit probe = new JavaTestKit(system);
            cm.registerTaskManager(probe.getRef(), resID1, ici, resources, 1, leaderSessionID);
            Assert.assertEquals((long)1L, (long)cm.getNumberOfRegisteredTaskManagers());
            Assert.assertEquals((long)1L, (long)cm.getTotalNumberOfSlots());
            try {
                cm.registerTaskManager(probe.getRef(), resID2, ici, resources, 1, leaderSessionID);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Assert.assertEquals((long)1L, (long)cm.getNumberOfRegisteredTaskManagers());
            Assert.assertEquals((long)1L, (long)cm.getTotalNumberOfSlots());
            cm.shutdown();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Test erroneous: " + e.getMessage()));
        }
    }

    @Test
    public void testReportHeartbeat() {
        try {
            InstanceManager cm = new InstanceManager();
            int dataPort = 20000;
            ResourceID resID1 = ResourceID.generate();
            ResourceID resID2 = ResourceID.generate();
            ResourceID resID3 = ResourceID.generate();
            HardwareDescription hardwareDescription = HardwareDescription.extractFromSystem((long)4096L);
            InetAddress address = InetAddress.getByName("127.0.0.1");
            InstanceConnectionInfo ici1 = new InstanceConnectionInfo(address, 20000);
            InstanceConnectionInfo ici2 = new InstanceConnectionInfo(address, 20001);
            InstanceConnectionInfo ici3 = new InstanceConnectionInfo(address, 20002);
            JavaTestKit probe1 = new JavaTestKit(system);
            JavaTestKit probe2 = new JavaTestKit(system);
            JavaTestKit probe3 = new JavaTestKit(system);
            InstanceID instanceID1 = cm.registerTaskManager(probe1.getRef(), resID1, ici1, hardwareDescription, 1, leaderSessionID);
            InstanceID instanceID2 = cm.registerTaskManager(probe2.getRef(), resID2, ici2, hardwareDescription, 1, leaderSessionID);
            InstanceID instanceID3 = cm.registerTaskManager(probe3.getRef(), resID3, ici3, hardwareDescription, 1, leaderSessionID);
            Assert.assertTrue((boolean)cm.reportHeartBeat(instanceID1, new byte[0]));
            Assert.assertTrue((boolean)cm.reportHeartBeat(instanceID2, new byte[0]));
            Assert.assertTrue((boolean)cm.reportHeartBeat(instanceID3, new byte[0]));
            Assert.assertFalse((boolean)cm.reportHeartBeat(new InstanceID(), new byte[0]));
            long WAIT = 200L;
            CommonTestUtils.sleepUninterruptibly(200L);
            Iterator it = cm.getAllRegisteredInstances().iterator();
            Instance instance1 = (Instance)it.next();
            long h1 = instance1.getLastHeartBeat();
            long h2 = ((Instance)it.next()).getLastHeartBeat();
            long h3 = ((Instance)it.next()).getLastHeartBeat();
            Assert.assertTrue((boolean)cm.reportHeartBeat(instance1.getId(), new byte[0]));
            long newH1 = instance1.getLastHeartBeat();
            long now = System.currentTimeMillis();
            Assert.assertTrue((now - h1 >= 200L ? 1 : 0) != 0);
            Assert.assertTrue((now - h2 >= 200L ? 1 : 0) != 0);
            Assert.assertTrue((now - h3 >= 200L ? 1 : 0) != 0);
            Assert.assertTrue((now - newH1 <= 200L ? 1 : 0) != 0);
            cm.shutdown();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Test erroneous: " + e.getMessage()));
        }
    }

    @Test
    public void testShutdown() {
        try {
            InstanceManager cm = new InstanceManager();
            cm.shutdown();
            try {
                ResourceID resID = ResourceID.generate();
                HardwareDescription resources = HardwareDescription.extractFromSystem((long)4096L);
                InetAddress address = InetAddress.getByName("127.0.0.1");
                InstanceConnectionInfo ici = new InstanceConnectionInfo(address, 20000);
                JavaTestKit probe = new JavaTestKit(system);
                cm.registerTaskManager(probe.getRef(), resID, ici, resources, 1, leaderSessionID);
                Assert.fail((String)"Should raise exception in shutdown state");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            Assert.assertFalse((boolean)cm.reportHeartBeat(new InstanceID(), new byte[0]));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Test erroneous: " + e.getMessage()));
        }
    }

    static {
        leaderSessionID = UUID.randomUUID();
    }
}

