/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.restart.NoRestartStrategy;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategy;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.instance.DummyActorGateway;
import org.apache.flink.runtime.instance.HardwareDescription;
import org.apache.flink.runtime.instance.Instance;
import org.apache.flink.runtime.instance.InstanceConnectionInfo;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.instance.SimpleSlot;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.scheduler.NoResourceAvailableException;
import org.apache.flink.runtime.jobmanager.scheduler.Scheduler;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.runtime.operators.testutils.DummyInvokable;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.util.SerializedValue;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;

public class VertexLocationConstraintTest {
    private static final FiniteDuration timeout = new FiniteDuration(100L, TimeUnit.SECONDS);

    @Test
    public void testScheduleWithConstraint1() {
        try {
            byte[] address1 = new byte[]{10, 0, 1, 4};
            byte[] address2 = new byte[]{10, 0, 1, 5};
            byte[] address3 = new byte[]{10, 0, 1, 6};
            String hostname1 = "host1";
            String hostname2 = "host2";
            String hostname3 = "host3";
            Instance instance1 = VertexLocationConstraintTest.getInstance(address1, 6789, "host1");
            Instance instance2 = VertexLocationConstraintTest.getInstance(address2, 6789, "host2");
            Instance instance3 = VertexLocationConstraintTest.getInstance(address3, 6789, "host3");
            Scheduler scheduler = new Scheduler((ExecutionContext)TestingUtils.defaultExecutionContext());
            scheduler.newInstanceAvailable(instance1);
            scheduler.newInstanceAvailable(instance2);
            scheduler.newInstanceAvailable(instance3);
            JobVertex jobVertex = new JobVertex("test vertex", new JobVertexID());
            jobVertex.setInvokableClass(DummyInvokable.class);
            jobVertex.setParallelism(2);
            JobGraph jg = new JobGraph("test job", new JobVertex[]{jobVertex});
            ExecutionGraph eg = new ExecutionGraph((ExecutionContext)TestingUtils.defaultExecutionContext(), jg.getJobID(), jg.getName(), jg.getJobConfiguration(), new SerializedValue((Object)new ExecutionConfig()), timeout, (RestartStrategy)new NoRestartStrategy());
            eg.attachJobGraph(Collections.singletonList(jobVertex));
            ExecutionJobVertex ejv = (ExecutionJobVertex)eg.getAllVertices().get(jobVertex.getID());
            ExecutionVertex[] vertices = ejv.getTaskVertices();
            vertices[0].setLocationConstraintHosts(Arrays.asList(instance1, instance2));
            vertices[1].setLocationConstraintHosts(Collections.singletonList(instance3));
            vertices[0].setScheduleLocalOnly(true);
            vertices[1].setScheduleLocalOnly(true);
            ejv.scheduleAll(scheduler, false);
            SimpleSlot slot1 = vertices[0].getCurrentAssignedResource();
            SimpleSlot slot2 = vertices[1].getCurrentAssignedResource();
            Assert.assertNotNull((Object)slot1);
            Assert.assertNotNull((Object)slot2);
            Instance target1 = slot1.getInstance();
            Instance target2 = slot2.getInstance();
            Assert.assertNotNull((Object)target1);
            Assert.assertNotNull((Object)target2);
            Assert.assertTrue((target1 == instance1 || target1 == instance2 ? 1 : 0) != 0);
            Assert.assertTrue((target2 == instance3 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testScheduleWithConstraint2() {
        try {
            byte[] address1 = new byte[]{10, 0, 1, 4};
            byte[] address2 = new byte[]{10, 0, 1, 5};
            byte[] address3 = new byte[]{10, 0, 1, 6};
            String hostname1 = "host1";
            String hostname2 = "host2";
            String hostname3 = "host3";
            Instance instance1 = VertexLocationConstraintTest.getInstance(address1, 6789, "host1");
            Instance instance2 = VertexLocationConstraintTest.getInstance(address2, 6789, "host2");
            Instance instance3 = VertexLocationConstraintTest.getInstance(address3, 6789, "host3");
            Scheduler scheduler = new Scheduler((ExecutionContext)TestingUtils.defaultExecutionContext());
            scheduler.newInstanceAvailable(instance1);
            scheduler.newInstanceAvailable(instance2);
            scheduler.newInstanceAvailable(instance3);
            JobVertex jobVertex = new JobVertex("test vertex", new JobVertexID());
            jobVertex.setInvokableClass(DummyInvokable.class);
            jobVertex.setParallelism(2);
            JobGraph jg = new JobGraph("test job", new JobVertex[]{jobVertex});
            ExecutionGraph eg = new ExecutionGraph((ExecutionContext)TestingUtils.defaultExecutionContext(), jg.getJobID(), jg.getName(), jg.getJobConfiguration(), new SerializedValue((Object)new ExecutionConfig()), timeout, (RestartStrategy)new NoRestartStrategy());
            eg.attachJobGraph(Collections.singletonList(jobVertex));
            ExecutionJobVertex ejv = (ExecutionJobVertex)eg.getAllVertices().get(jobVertex.getID());
            ExecutionVertex[] vertices = ejv.getTaskVertices();
            vertices[0].setLocationConstraintHosts(Collections.singletonList(instance3));
            vertices[1].setLocationConstraintHosts(Arrays.asList(instance1, instance2));
            vertices[0].setScheduleLocalOnly(true);
            vertices[1].setScheduleLocalOnly(true);
            ejv.scheduleAll(scheduler, false);
            SimpleSlot slot1 = vertices[0].getCurrentAssignedResource();
            SimpleSlot slot2 = vertices[1].getCurrentAssignedResource();
            Assert.assertNotNull((Object)slot1);
            Assert.assertNotNull((Object)slot2);
            Instance target1 = slot1.getInstance();
            Instance target2 = slot2.getInstance();
            Assert.assertNotNull((Object)target1);
            Assert.assertNotNull((Object)target2);
            Assert.assertTrue((target1 == instance3 ? 1 : 0) != 0);
            Assert.assertTrue((target2 == instance1 || target2 == instance2 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testScheduleWithConstraintAndSlotSharing() {
        try {
            byte[] address1 = new byte[]{10, 0, 1, 4};
            byte[] address2 = new byte[]{10, 0, 1, 5};
            byte[] address3 = new byte[]{10, 0, 1, 6};
            String hostname1 = "host1";
            String hostname2 = "host2";
            String hostname3 = "host3";
            Instance instance1 = VertexLocationConstraintTest.getInstance(address1, 6789, "host1");
            Instance instance2 = VertexLocationConstraintTest.getInstance(address2, 6789, "host2");
            Instance instance3 = VertexLocationConstraintTest.getInstance(address3, 6789, "host3");
            Scheduler scheduler = new Scheduler((ExecutionContext)TestingUtils.defaultExecutionContext());
            scheduler.newInstanceAvailable(instance1);
            scheduler.newInstanceAvailable(instance2);
            scheduler.newInstanceAvailable(instance3);
            JobVertex jobVertex1 = new JobVertex("v1", new JobVertexID());
            JobVertex jobVertex2 = new JobVertex("v2", new JobVertexID());
            jobVertex1.setInvokableClass(DummyInvokable.class);
            jobVertex2.setInvokableClass(DummyInvokable.class);
            jobVertex1.setParallelism(2);
            jobVertex2.setParallelism(3);
            SlotSharingGroup sharingGroup = new SlotSharingGroup();
            jobVertex1.setSlotSharingGroup(sharingGroup);
            jobVertex2.setSlotSharingGroup(sharingGroup);
            JobGraph jg = new JobGraph("test job", new JobVertex[]{jobVertex1, jobVertex2});
            ExecutionGraph eg = new ExecutionGraph((ExecutionContext)TestingUtils.defaultExecutionContext(), jg.getJobID(), jg.getName(), jg.getJobConfiguration(), new SerializedValue((Object)new ExecutionConfig()), timeout, (RestartStrategy)new NoRestartStrategy());
            eg.attachJobGraph(Arrays.asList(jobVertex1, jobVertex2));
            ExecutionJobVertex ejv = (ExecutionJobVertex)eg.getAllVertices().get(jobVertex1.getID());
            ExecutionVertex[] vertices = ejv.getTaskVertices();
            vertices[0].setLocationConstraintHosts(Arrays.asList(instance1, instance2));
            vertices[1].setLocationConstraintHosts(Collections.singletonList(instance3));
            vertices[0].setScheduleLocalOnly(true);
            vertices[1].setScheduleLocalOnly(true);
            ejv.scheduleAll(scheduler, false);
            SimpleSlot slot1 = vertices[0].getCurrentAssignedResource();
            SimpleSlot slot2 = vertices[1].getCurrentAssignedResource();
            Assert.assertNotNull((Object)slot1);
            Assert.assertNotNull((Object)slot2);
            Instance target1 = slot1.getInstance();
            Instance target2 = slot2.getInstance();
            Assert.assertNotNull((Object)target1);
            Assert.assertNotNull((Object)target2);
            Assert.assertTrue((target1 == instance1 || target1 == instance2 ? 1 : 0) != 0);
            Assert.assertTrue((target2 == instance3 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testScheduleWithUnfulfillableConstraint() {
        try {
            byte[] address1 = new byte[]{10, 0, 1, 4};
            byte[] address2 = new byte[]{10, 0, 1, 5};
            String hostname1 = "host1";
            String hostname2 = "host2";
            Instance instance1 = VertexLocationConstraintTest.getInstance(address1, 6789, "host1");
            Instance instance2 = VertexLocationConstraintTest.getInstance(address2, 6789, "host2");
            Scheduler scheduler = new Scheduler((ExecutionContext)TestingUtils.defaultExecutionContext());
            scheduler.newInstanceAvailable(instance1);
            JobVertex jobVertex = new JobVertex("test vertex", new JobVertexID());
            jobVertex.setInvokableClass(DummyInvokable.class);
            jobVertex.setParallelism(1);
            JobGraph jg = new JobGraph("test job", new JobVertex[]{jobVertex});
            ExecutionGraph eg = new ExecutionGraph((ExecutionContext)TestingUtils.defaultExecutionContext(), jg.getJobID(), jg.getName(), jg.getJobConfiguration(), new SerializedValue((Object)new ExecutionConfig()), timeout, (RestartStrategy)new NoRestartStrategy());
            eg.attachJobGraph(Collections.singletonList(jobVertex));
            ExecutionJobVertex ejv = (ExecutionJobVertex)eg.getAllVertices().get(jobVertex.getID());
            ExecutionVertex[] vertices = ejv.getTaskVertices();
            vertices[0].setLocationConstraintHosts(Collections.singletonList(instance2));
            vertices[0].setScheduleLocalOnly(true);
            try {
                ejv.scheduleAll(scheduler, false);
                Assert.fail((String)"This should fail with a NoResourceAvailableException");
            }
            catch (NoResourceAvailableException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("host2"));
            }
            catch (Exception e) {
                Assert.fail((String)"Wrong exception type");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testScheduleWithUnfulfillableConstraintInSharingGroup() {
        try {
            byte[] address1 = new byte[]{10, 0, 1, 4};
            byte[] address2 = new byte[]{10, 0, 1, 5};
            String hostname1 = "host1";
            String hostname2 = "host2";
            Instance instance1 = VertexLocationConstraintTest.getInstance(address1, 6789, "host1");
            Instance instance2 = VertexLocationConstraintTest.getInstance(address2, 6789, "host2");
            Scheduler scheduler = new Scheduler((ExecutionContext)TestingUtils.defaultExecutionContext());
            scheduler.newInstanceAvailable(instance1);
            JobVertex jobVertex1 = new JobVertex("v1", new JobVertexID());
            JobVertex jobVertex2 = new JobVertex("v2", new JobVertexID());
            jobVertex1.setInvokableClass(DummyInvokable.class);
            jobVertex2.setInvokableClass(DummyInvokable.class);
            jobVertex1.setParallelism(1);
            jobVertex2.setParallelism(1);
            JobGraph jg = new JobGraph("test job", new JobVertex[]{jobVertex1, jobVertex2});
            SlotSharingGroup sharingGroup = new SlotSharingGroup();
            jobVertex1.setSlotSharingGroup(sharingGroup);
            jobVertex2.setSlotSharingGroup(sharingGroup);
            ExecutionGraph eg = new ExecutionGraph((ExecutionContext)TestingUtils.defaultExecutionContext(), jg.getJobID(), jg.getName(), jg.getJobConfiguration(), new SerializedValue((Object)new ExecutionConfig()), timeout, (RestartStrategy)new NoRestartStrategy());
            eg.attachJobGraph(Arrays.asList(jobVertex1, jobVertex2));
            ExecutionJobVertex ejv = (ExecutionJobVertex)eg.getAllVertices().get(jobVertex1.getID());
            ExecutionVertex[] vertices = ejv.getTaskVertices();
            vertices[0].setLocationConstraintHosts(Collections.singletonList(instance2));
            vertices[0].setScheduleLocalOnly(true);
            try {
                ejv.scheduleAll(scheduler, false);
                Assert.fail((String)"This should fail with a NoResourceAvailableException");
            }
            catch (NoResourceAvailableException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("host2"));
            }
            catch (Exception e) {
                Assert.fail((String)"Wrong exception type");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testArchivingClearsFields() {
        try {
            JobVertex vertex = new JobVertex("test vertex", new JobVertexID());
            JobGraph jg = new JobGraph("test job", new JobVertex[]{vertex});
            ExecutionGraph eg = new ExecutionGraph((ExecutionContext)TestingUtils.defaultExecutionContext(), jg.getJobID(), jg.getName(), jg.getJobConfiguration(), new SerializedValue((Object)new ExecutionConfig()), timeout, (RestartStrategy)new NoRestartStrategy());
            eg.attachJobGraph(Collections.singletonList(vertex));
            ExecutionVertex ev = ((ExecutionJobVertex)eg.getAllVertices().get(vertex.getID())).getTaskVertices()[0];
            Instance instance = ExecutionGraphTestUtils.getInstance(DummyActorGateway.INSTANCE);
            ev.setLocationConstraintHosts(Collections.singletonList(instance));
            Assert.assertNotNull((Object)ev.getPreferredLocations());
            Assert.assertEquals((Object)instance, ev.getPreferredLocations().iterator().next());
            eg.fail((Throwable)new Exception());
            eg.prepareForArchiving();
            Assert.assertTrue((ev.getPreferredLocations() == null || !ev.getPreferredLocations().iterator().hasNext() ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    public static Instance getInstance(byte[] ipAddress, int dataPort, String hostname) throws Exception {
        HardwareDescription hardwareDescription = new HardwareDescription(4, 0x80000000L, 0x40000000L, 0x20000000L);
        InstanceConnectionInfo connection = (InstanceConnectionInfo)Mockito.mock(InstanceConnectionInfo.class);
        Mockito.when((Object)connection.address()).thenReturn((Object)InetAddress.getByAddress(ipAddress));
        Mockito.when((Object)connection.dataPort()).thenReturn((Object)dataPort);
        Mockito.when((Object)connection.getInetAdress()).thenReturn((Object)InetAddress.getByAddress(ipAddress).toString());
        Mockito.when((Object)connection.getHostname()).thenReturn((Object)hostname);
        Mockito.when((Object)connection.getFQDNHostname()).thenReturn((Object)hostname);
        return new Instance((ActorGateway)new ExecutionGraphTestUtils.SimpleActorGateway((ExecutionContext)TestingUtils.defaultExecutionContext()), connection, ResourceID.generate(), new InstanceID(), hardwareDescription, 1);
    }
}

