/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import akka.actor.ActorSystem;
import akka.testkit.JavaTestKit;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.IntermediateResult;
import org.apache.flink.runtime.instance.BaseTestingActorGateway;
import org.apache.flink.runtime.instance.Instance;
import org.apache.flink.runtime.instance.SimpleSlot;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.messages.Messages;
import org.apache.flink.runtime.messages.TaskMessages;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.util.TestLogger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import scala.concurrent.ExecutionContext;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={ExecutionVertex.class})
public class ExecutionVertexStopTest
extends TestLogger {
    private static ActorSystem system;
    private static boolean receivedStopSignal;

    @AfterClass
    public static void teardown() {
        if (system != null) {
            JavaTestKit.shutdownActorSystem((ActorSystem)system);
            system = null;
        }
    }

    @Test
    public void testStop() throws Exception {
        JobVertexID jid = new JobVertexID();
        ExecutionJobVertex ejv = ExecutionGraphTestUtils.getExecutionVertex(jid);
        Execution executionMock = (Execution)Mockito.mock(Execution.class);
        PowerMockito.whenNew(Execution.class).withAnyArguments().thenReturn((Object)executionMock);
        ExecutionVertex vertex = new ExecutionVertex(ejv, 0, new IntermediateResult[0], AkkaUtils.getDefaultTimeout());
        vertex.stop();
        ((Execution)Mockito.verify((Object)executionMock)).stop();
    }

    @Test
    public void testStopRpc() throws Exception {
        JobVertexID jid = new JobVertexID();
        ExecutionJobVertex ejv = ExecutionGraphTestUtils.getExecutionVertex(jid);
        ExecutionVertex vertex = new ExecutionVertex(ejv, 0, new IntermediateResult[0], AkkaUtils.getDefaultTimeout());
        ExecutionAttemptID execId = vertex.getCurrentExecutionAttempt().getAttemptId();
        ExecutionGraphTestUtils.setVertexState(vertex, ExecutionState.SCHEDULED);
        Assert.assertEquals((Object)ExecutionState.SCHEDULED, (Object)vertex.getExecutionState());
        StopSequenceInstanceGateway gateway = new StopSequenceInstanceGateway((ExecutionContext)TestingUtils.defaultExecutionContext(), new TaskMessages.TaskOperationResult(execId, true));
        Instance instance = ExecutionGraphTestUtils.getInstance(gateway);
        SimpleSlot slot = instance.allocateSimpleSlot(new JobID());
        vertex.deployToSlot(slot);
        receivedStopSignal = false;
        vertex.stop();
        Assert.assertTrue((boolean)receivedStopSignal);
    }

    public static class StopSequenceInstanceGateway
    extends BaseTestingActorGateway {
        private static final long serialVersionUID = 7611571264006653627L;
        private final TaskMessages.TaskOperationResult result;

        public StopSequenceInstanceGateway(ExecutionContext executionContext, TaskMessages.TaskOperationResult result) {
            super(executionContext);
            this.result = result;
        }

        @Override
        public Object handleMessage(Object message) throws Exception {
            Messages.Acknowledge$ result = null;
            if (message instanceof TaskMessages.SubmitTask) {
                result = Messages.getAcknowledge();
            } else if (message instanceof TaskMessages.StopTask) {
                result = this.result;
                receivedStopSignal = true;
            }
            return result;
        }
    }
}

