/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.StoppingException;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.IntermediateResult;
import org.apache.flink.runtime.executiongraph.restart.NoRestartStrategy;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategy;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.util.SerializedValue;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={ExecutionGraph.class})
public class ExecutionGraphSignalsTest {
    private ExecutionJobVertex[] mockEJV = new ExecutionJobVertex[5];
    private int[] dop = new int[]{5, 7, 2, 11, 4};
    private ExecutionVertex[][] mockEV = new ExecutionVertex[this.mockEJV.length][];
    private ExecutionGraph eg;
    private Field f;

    @Before
    public void prepare() throws Exception {
        JobID jobId = new JobID();
        String jobName = "Test Job Sample Name";
        Configuration cfg = new Configuration();
        assert (this.mockEJV.length == 5);
        JobVertex v1 = new JobVertex("vertex1");
        JobVertex v2 = new JobVertex("vertex2");
        JobVertex v3 = new JobVertex("vertex3");
        JobVertex v4 = new JobVertex("vertex4");
        JobVertex v5 = new JobVertex("vertex5");
        for (int i = 0; i < this.mockEJV.length; ++i) {
            this.mockEJV[i] = (ExecutionJobVertex)Mockito.mock(ExecutionJobVertex.class);
            this.mockEV[i] = new ExecutionVertex[this.dop[i]];
            for (int j = 0; j < this.dop[i]; ++j) {
                this.mockEV[i][j] = (ExecutionVertex)Mockito.mock(ExecutionVertex.class);
            }
            Mockito.when((Object)this.mockEJV[i].getProducedDataSets()).thenReturn((Object)new IntermediateResult[0]);
            Mockito.when((Object)this.mockEJV[i].getTaskVertices()).thenReturn((Object)this.mockEV[i]);
        }
        PowerMockito.whenNew(ExecutionJobVertex.class).withArguments(Mockito.any(ExecutionGraph.class), new Object[]{Mockito.same((Object)v1), (int)((Integer)Mockito.any(Integer.class)), Mockito.any(FiniteDuration.class), (long)((Long)Mockito.any(Long.class))}).thenReturn((Object)this.mockEJV[0]);
        PowerMockito.whenNew(ExecutionJobVertex.class).withArguments(Mockito.any(ExecutionGraph.class), new Object[]{Mockito.same((Object)v2), (int)((Integer)Mockito.any(Integer.class)), Mockito.any(FiniteDuration.class), (long)((Long)Mockito.any(Long.class))}).thenReturn((Object)this.mockEJV[1]);
        PowerMockito.whenNew(ExecutionJobVertex.class).withArguments(Mockito.any(ExecutionGraph.class), new Object[]{Mockito.same((Object)v3), (int)((Integer)Mockito.any(Integer.class)), Mockito.any(FiniteDuration.class), (long)((Long)Mockito.any(Long.class))}).thenReturn((Object)this.mockEJV[2]);
        PowerMockito.whenNew(ExecutionJobVertex.class).withArguments(Mockito.any(ExecutionGraph.class), new Object[]{Mockito.same((Object)v4), (int)((Integer)Mockito.any(Integer.class)), Mockito.any(FiniteDuration.class), (long)((Long)Mockito.any(Long.class))}).thenReturn((Object)this.mockEJV[3]);
        PowerMockito.whenNew(ExecutionJobVertex.class).withArguments(Mockito.any(ExecutionGraph.class), new Object[]{Mockito.same((Object)v5), (int)((Integer)Mockito.any(Integer.class)), Mockito.any(FiniteDuration.class), (long)((Long)Mockito.any(Long.class))}).thenReturn((Object)this.mockEJV[4]);
        v1.setParallelism(this.dop[0]);
        v2.setParallelism(this.dop[1]);
        v3.setParallelism(this.dop[2]);
        v4.setParallelism(this.dop[3]);
        v5.setParallelism(this.dop[4]);
        v2.connectNewDataSetAsInput(v1, DistributionPattern.ALL_TO_ALL);
        this.mockNumberOfInputs(1, 0);
        v4.connectNewDataSetAsInput(v2, DistributionPattern.ALL_TO_ALL);
        this.mockNumberOfInputs(3, 1);
        v4.connectNewDataSetAsInput(v3, DistributionPattern.ALL_TO_ALL);
        this.mockNumberOfInputs(3, 2);
        v5.connectNewDataSetAsInput(v4, DistributionPattern.ALL_TO_ALL);
        this.mockNumberOfInputs(4, 3);
        v5.connectNewDataSetAsInput(v3, DistributionPattern.ALL_TO_ALL);
        this.mockNumberOfInputs(4, 2);
        ArrayList<JobVertex> ordered = new ArrayList<JobVertex>(Arrays.asList(v1, v2, v3, v4, v5));
        this.eg = new ExecutionGraph((ExecutionContext)TestingUtils.defaultExecutionContext(), jobId, "Test Job Sample Name", cfg, new SerializedValue((Object)new ExecutionConfig()), AkkaUtils.getDefaultTimeout(), (RestartStrategy)new NoRestartStrategy());
        this.eg.attachJobGraph(ordered);
        this.f = this.eg.getClass().getDeclaredField("state");
        this.f.setAccessible(true);
    }

    private void mockNumberOfInputs(int nodeIndex, int predecessorIndex) {
        for (int j = 0; j < this.dop[nodeIndex]; ++j) {
            Mockito.when((Object)this.mockEV[nodeIndex][j].getNumberOfInputs()).thenReturn((Object)this.dop[predecessorIndex]);
        }
    }

    @Test
    public void testCancel() throws Exception {
        Assert.assertEquals((Object)JobStatus.CREATED, (Object)this.eg.getState());
        this.eg.cancel();
        this.verifyCancel(1);
        this.f.set(this.eg, JobStatus.RUNNING);
        this.eg.cancel();
        this.verifyCancel(2);
        Assert.assertEquals((Object)JobStatus.CANCELLING, (Object)this.eg.getState());
        this.eg.cancel();
        this.verifyCancel(2);
        Assert.assertEquals((Object)JobStatus.CANCELLING, (Object)this.eg.getState());
        this.f.set(this.eg, JobStatus.CANCELED);
        this.eg.cancel();
        this.verifyCancel(2);
        Assert.assertEquals((Object)JobStatus.CANCELED, (Object)this.eg.getState());
        this.f.set(this.eg, JobStatus.FAILED);
        this.eg.cancel();
        this.verifyCancel(2);
        Assert.assertEquals((Object)JobStatus.FAILED, (Object)this.eg.getState());
        this.f.set(this.eg, JobStatus.FAILING);
        this.eg.cancel();
        this.verifyCancel(2);
        Assert.assertEquals((Object)JobStatus.CANCELLING, (Object)this.eg.getState());
        this.f.set(this.eg, JobStatus.FINISHED);
        this.eg.cancel();
        this.verifyCancel(2);
        Assert.assertEquals((Object)JobStatus.FINISHED, (Object)this.eg.getState());
        this.f.set(this.eg, JobStatus.RESTARTING);
        this.eg.cancel();
        this.verifyCancel(2);
        Assert.assertEquals((Object)JobStatus.CANCELED, (Object)this.eg.getState());
    }

    private void verifyCancel(int times) {
        for (int i = 0; i < this.mockEJV.length; ++i) {
            ((ExecutionJobVertex)Mockito.verify((Object)this.mockEJV[i], (VerificationMode)Mockito.times((int)times))).cancel();
        }
    }

    @Test
    public void testSuspend() throws Exception {
        Assert.assertEquals((Object)JobStatus.CREATED, (Object)this.eg.getState());
        Exception testException = new Exception("Test exception");
        this.eg.suspend((Throwable)testException);
        this.verifyCancel(1);
        Assert.assertEquals((Object)JobStatus.SUSPENDED, (Object)this.eg.getState());
        this.f.set(this.eg, JobStatus.RUNNING);
        this.eg.suspend((Throwable)testException);
        this.verifyCancel(2);
        Assert.assertEquals((Object)JobStatus.SUSPENDED, (Object)this.eg.getState());
        this.f.set(this.eg, JobStatus.FAILING);
        this.eg.suspend((Throwable)testException);
        this.verifyCancel(3);
        Assert.assertEquals((Object)JobStatus.SUSPENDED, (Object)this.eg.getState());
        this.f.set(this.eg, JobStatus.CANCELLING);
        this.eg.suspend((Throwable)testException);
        this.verifyCancel(4);
        Assert.assertEquals((Object)JobStatus.SUSPENDED, (Object)this.eg.getState());
        this.f.set(this.eg, JobStatus.FAILED);
        this.eg.suspend((Throwable)testException);
        this.verifyCancel(4);
        Assert.assertEquals((Object)JobStatus.FAILED, (Object)this.eg.getState());
        this.f.set(this.eg, JobStatus.FINISHED);
        this.eg.suspend((Throwable)testException);
        this.verifyCancel(4);
        Assert.assertEquals((Object)JobStatus.FINISHED, (Object)this.eg.getState());
        this.f.set(this.eg, JobStatus.CANCELED);
        this.eg.suspend((Throwable)testException);
        this.verifyCancel(4);
        Assert.assertEquals((Object)JobStatus.CANCELED, (Object)this.eg.getState());
        this.f.set(this.eg, JobStatus.SUSPENDED);
        this.eg.fail((Throwable)testException);
        Assert.assertEquals((Object)JobStatus.SUSPENDED, (Object)this.eg.getState());
        this.eg.cancel();
        Assert.assertEquals((Object)JobStatus.SUSPENDED, (Object)this.eg.getState());
    }

    @Test
    public void testStop() throws Exception {
        int j;
        Field f = this.eg.getClass().getDeclaredField("isStoppable");
        f.setAccessible(true);
        f.set(this.eg, true);
        this.eg.stop();
        for (int i : new int[]{0, 2}) {
            for (j = 0; j < this.mockEV[i].length; ++j) {
                ((ExecutionVertex)Mockito.verify((Object)this.mockEV[i][j], (VerificationMode)Mockito.times((int)1))).stop();
            }
        }
        for (int i : new int[]{1, 3, 4}) {
            for (j = 0; j < this.mockEV[i].length; ++j) {
                ((ExecutionVertex)Mockito.verify((Object)this.mockEV[i][j], (VerificationMode)Mockito.times((int)0))).stop();
            }
        }
    }

    @Test(expected=StoppingException.class)
    public void testStopBatching() throws StoppingException {
        this.eg.stop();
    }
}

