/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.event.task;

import java.io.IOException;
import java.util.Iterator;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.runtime.event.task.EventList;
import org.apache.flink.runtime.event.task.IntegerTaskEvent;
import org.apache.flink.runtime.event.task.StringTaskEvent;
import org.apache.flink.util.InstantiationUtil;
import org.junit.Assert;
import org.junit.Test;

public class TaskEventTest {
    @Test
    public void testIntegerTaskEvent() {
        try {
            IntegerTaskEvent orig = new IntegerTaskEvent(11);
            IntegerTaskEvent copy = (IntegerTaskEvent)InstantiationUtil.createCopyWritable((IOReadableWritable)orig);
            Assert.assertEquals((long)orig.getInteger(), (long)copy.getInteger());
            Assert.assertEquals((long)orig.hashCode(), (long)copy.hashCode());
            Assert.assertTrue((boolean)orig.equals((Object)copy));
        }
        catch (IOException ioe) {
            Assert.fail((String)ioe.getMessage());
        }
    }

    @Test
    public void testStringTaskEvent() {
        try {
            StringTaskEvent orig = new StringTaskEvent("Test");
            StringTaskEvent copy = (StringTaskEvent)InstantiationUtil.createCopyWritable((IOReadableWritable)orig);
            Assert.assertEquals((Object)orig.getString(), (Object)copy.getString());
            Assert.assertEquals((long)orig.hashCode(), (long)copy.hashCode());
            Assert.assertTrue((boolean)orig.equals((Object)copy));
        }
        catch (IOException ioe) {
            Assert.fail((String)ioe.getMessage());
        }
    }

    @Test
    public void testEventList() {
        try {
            EventList orig = new EventList();
            orig.add((Object)new StringTaskEvent("Test 2"));
            orig.add((Object)new IntegerTaskEvent(70));
            EventList copy = (EventList)InstantiationUtil.createCopyWritable((IOReadableWritable)orig);
            Assert.assertEquals((long)orig.size(), (long)copy.size());
            Iterator origIt = orig.iterator();
            Iterator copyIt = copy.iterator();
            while (origIt.hasNext()) {
                Assert.assertEquals(origIt.next(), copyIt.next());
            }
        }
        catch (IOException ioe) {
            Assert.fail((String)ioe.getMessage());
        }
    }
}

