/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.savepoint;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.flink.runtime.checkpoint.SubtaskState;
import org.apache.flink.runtime.checkpoint.TaskState;
import org.apache.flink.runtime.checkpoint.savepoint.SavepointV0;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.messages.CheckpointMessagesTest;
import org.apache.flink.util.SerializedValue;
import org.junit.Assert;
import org.junit.Test;

public class SavepointV01Test {
    @Test
    public void testSavepointV1() throws Exception {
        long checkpointId = ThreadLocalRandom.current().nextLong(Integer.MAX_VALUE);
        int numTaskStates = 4;
        int numSubtaskStates = 16;
        Collection<TaskState> expected = SavepointV01Test.createTaskStates(numTaskStates, numSubtaskStates);
        SavepointV0 savepoint = new SavepointV0(checkpointId, expected);
        Assert.assertEquals((long)0L, (long)savepoint.getVersion());
        Assert.assertEquals((long)checkpointId, (long)savepoint.getCheckpointId());
        Assert.assertEquals(expected, (Object)savepoint.getTaskStates());
        Assert.assertFalse((boolean)savepoint.getTaskStates().isEmpty());
        savepoint.dispose(ClassLoader.getSystemClassLoader());
        Assert.assertTrue((boolean)savepoint.getTaskStates().isEmpty());
    }

    static Collection<TaskState> createTaskStates(int numTaskStates, int numSubtaskStates) throws IOException {
        ArrayList<TaskState> taskStates = new ArrayList<TaskState>(numTaskStates);
        for (int i = 0; i < numTaskStates; ++i) {
            TaskState taskState = new TaskState(new JobVertexID(), numSubtaskStates);
            for (int j = 0; j < numSubtaskStates; ++j) {
                SerializedValue stateHandle = new SerializedValue((Object)new CheckpointMessagesTest.MyHandle());
                taskState.putState(i, new SubtaskState(stateHandle, 0L, 0L));
            }
            taskStates.add(taskState);
        }
        return taskStates;
    }
}

