/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStoreTest;
import org.apache.flink.runtime.checkpoint.StandaloneCompletedCheckpointStore;
import org.junit.Assert;
import org.junit.Test;

public class StandaloneCompletedCheckpointStoreTest
extends CompletedCheckpointStoreTest {
    @Override
    protected CompletedCheckpointStore createCompletedCheckpoints(int maxNumberOfCheckpointsToRetain, ClassLoader userClassLoader) throws Exception {
        return new StandaloneCompletedCheckpointStore(maxNumberOfCheckpointsToRetain, userClassLoader);
    }

    @Test
    public void testShutdownDiscardsCheckpoints() throws Exception {
        CompletedCheckpointStore store = this.createCompletedCheckpoints(1, ClassLoader.getSystemClassLoader());
        CompletedCheckpointStoreTest.TestCompletedCheckpoint checkpoint = this.createCheckpoint(0);
        store.addCheckpoint((CompletedCheckpoint)checkpoint);
        Assert.assertEquals((long)1L, (long)store.getNumberOfRetainedCheckpoints());
        store.shutdown();
        Assert.assertEquals((long)0L, (long)store.getNumberOfRetainedCheckpoints());
        Assert.assertTrue((boolean)checkpoint.isDiscarded());
    }

    @Test
    public void testSuspendDiscardsCheckpoints() throws Exception {
        CompletedCheckpointStore store = this.createCompletedCheckpoints(1, ClassLoader.getSystemClassLoader());
        CompletedCheckpointStoreTest.TestCompletedCheckpoint checkpoint = this.createCheckpoint(0);
        store.addCheckpoint((CompletedCheckpoint)checkpoint);
        Assert.assertEquals((long)1L, (long)store.getNumberOfRetainedCheckpoints());
        store.suspend();
        Assert.assertEquals((long)0L, (long)store.getNumberOfRetainedCheckpoints());
        Assert.assertTrue((boolean)checkpoint.isDiscarded());
    }
}

