/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import akka.actor.ActorSystem;
import akka.testkit.JavaTestKit;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.checkpoint.CheckpointCoordinator;
import org.apache.flink.runtime.checkpoint.CheckpointIDCounter;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;
import org.apache.flink.runtime.checkpoint.StandaloneCheckpointIDCounter;
import org.apache.flink.runtime.checkpoint.StandaloneCompletedCheckpointStore;
import org.apache.flink.runtime.checkpoint.savepoint.HeapSavepointStore;
import org.apache.flink.runtime.checkpoint.savepoint.SavepointCoordinator;
import org.apache.flink.runtime.checkpoint.savepoint.SavepointStore;
import org.apache.flink.runtime.checkpoint.stats.CheckpointStatsTracker;
import org.apache.flink.runtime.checkpoint.stats.DisabledCheckpointStatsTracker;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.restart.NoRestartStrategy;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategy;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobmanager.RecoveryMode;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.util.SerializedValue;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;

public class ExecutionGraphCheckpointCoordinatorTest {
    private static ActorSystem system = AkkaUtils.createLocalActorSystem((Configuration)new Configuration());

    @AfterClass
    public static void teardown() {
        JavaTestKit.shutdownActorSystem((ActorSystem)system);
    }

    @Test
    public void testCheckpointAndSavepointCoordinatorShareCheckpointIDCounter() throws Exception {
        ExecutionGraph executionGraph = this.createExecutionGraphAndEnableCheckpointing((CheckpointIDCounter)new StandaloneCheckpointIDCounter(), (CompletedCheckpointStore)new StandaloneCompletedCheckpointStore(1, ClassLoader.getSystemClassLoader()));
        CheckpointCoordinator checkpointCoordinator = executionGraph.getCheckpointCoordinator();
        SavepointCoordinator savepointCoordinator = executionGraph.getSavepointCoordinator();
        Field counterField = CheckpointCoordinator.class.getDeclaredField("checkpointIdCounter");
        CheckpointIDCounter counterCheckpointCoordinator = (CheckpointIDCounter)counterField.get(checkpointCoordinator);
        CheckpointIDCounter counterSavepointCoordinator = (CheckpointIDCounter)counterField.get(savepointCoordinator);
        Assert.assertEquals((Object)counterCheckpointCoordinator, (Object)counterSavepointCoordinator);
    }

    @Test
    public void testShutdownCheckpointCoordinator() throws Exception {
        CheckpointIDCounter counter = (CheckpointIDCounter)Mockito.mock(CheckpointIDCounter.class);
        CompletedCheckpointStore store = (CompletedCheckpointStore)Mockito.mock(CompletedCheckpointStore.class);
        ExecutionGraph graph = this.createExecutionGraphAndEnableCheckpointing(counter, store);
        graph.fail((Throwable)new Exception("Test Exception"));
        ((CheckpointIDCounter)Mockito.verify((Object)counter, (VerificationMode)Mockito.times((int)2))).shutdown();
        ((CompletedCheckpointStore)Mockito.verify((Object)store, (VerificationMode)Mockito.times((int)1))).shutdown();
    }

    @Test
    public void testSuspendCheckpointCoordinator() throws Exception {
        CheckpointIDCounter counter = (CheckpointIDCounter)Mockito.mock(CheckpointIDCounter.class);
        CompletedCheckpointStore store = (CompletedCheckpointStore)Mockito.mock(CompletedCheckpointStore.class);
        ExecutionGraph graph = this.createExecutionGraphAndEnableCheckpointing(counter, store);
        graph.suspend((Throwable)new Exception("Test Exception"));
        ((CheckpointIDCounter)Mockito.verify((Object)counter, (VerificationMode)Mockito.times((int)0))).shutdown();
        ((CompletedCheckpointStore)Mockito.verify((Object)store, (VerificationMode)Mockito.times((int)0))).shutdown();
        ((CheckpointIDCounter)Mockito.verify((Object)counter, (VerificationMode)Mockito.times((int)2))).suspend();
        ((CompletedCheckpointStore)Mockito.verify((Object)store, (VerificationMode)Mockito.times((int)1))).suspend();
    }

    private ExecutionGraph createExecutionGraphAndEnableCheckpointing(CheckpointIDCounter counter, CompletedCheckpointStore store) throws Exception {
        ExecutionGraph executionGraph = new ExecutionGraph((ExecutionContext)TestingUtils.defaultExecutionContext(), new JobID(), "test", new Configuration(), new SerializedValue((Object)new ExecutionConfig()), new FiniteDuration(1L, TimeUnit.DAYS), (RestartStrategy)new NoRestartStrategy(), Collections.emptyList(), Collections.emptyList(), ClassLoader.getSystemClassLoader(), (MetricGroup)new UnregisteredMetricsGroup());
        executionGraph.enableSnapshotCheckpointing(100L, 100L, 100L, 1, 42, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), system, UUID.randomUUID(), counter, store, RecoveryMode.STANDALONE, (SavepointStore)new HeapSavepointStore(), (CheckpointStatsTracker)new DisabledCheckpointStatsTracker());
        JobVertex jobVertex = new JobVertex("MockVertex");
        executionGraph.attachJobGraph(Collections.singletonList(jobVertex));
        return executionGraph;
    }
}

