/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.Random;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobClient;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobServerConnection;
import org.apache.flink.runtime.blob.BlobUtils;
import org.junit.Assert;
import org.junit.Test;

public class BlobServerGetTest {
    private final Random rnd = new Random();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetFailsDuringLookup() {
        BlobServer server = null;
        BlobClient client = null;
        try {
            Configuration config = new Configuration();
            server = new BlobServer(config);
            InetSocketAddress serverAddress = new InetSocketAddress("localhost", server.getPort());
            client = new BlobClient(serverAddress);
            byte[] data = new byte[2000000];
            this.rnd.nextBytes(data);
            BlobKey key = client.put(data);
            Assert.assertNotNull((Object)key);
            File blobFile = server.getStorageLocation(key);
            Assert.assertTrue((boolean)blobFile.delete());
            try {
                client.get(key);
                Assert.fail((String)"This should not succeed.");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (client != null) {
                try {
                    client.close();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            if (server != null) {
                server.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetFailsDuringStreaming() {
        BlobServer server = null;
        BlobClient client = null;
        try {
            Configuration config = new Configuration();
            server = new BlobServer(config);
            InetSocketAddress serverAddress = new InetSocketAddress("localhost", server.getPort());
            client = new BlobClient(serverAddress);
            byte[] data = new byte[5000000];
            this.rnd.nextBytes(data);
            BlobKey key = client.put(data);
            Assert.assertNotNull((Object)key);
            InputStream is = client.get(key);
            byte[] receiveBuffer = new byte[50000];
            BlobUtils.readFully((InputStream)is, (byte[])receiveBuffer, (int)0, (int)receiveBuffer.length, null);
            BlobUtils.readFully((InputStream)is, (byte[])receiveBuffer, (int)0, (int)receiveBuffer.length, null);
            for (BlobServerConnection conn : server.getCurrentActiveConnections()) {
                conn.close();
            }
            try {
                byte[] remainder = new byte[data.length - 2 * receiveBuffer.length];
                BlobUtils.readFully((InputStream)is, (byte[])remainder, (int)0, (int)remainder.length, null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (client != null) {
                try {
                    client.close();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            if (server != null) {
                server.shutdown();
            }
        }
    }
}

