/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.util.Random;
import org.apache.flink.runtime.util.LRUCacheMap;
import org.junit.Assert;
import org.junit.Test;

public class LRUCacheMapTest {
    @Test
    public void testGetAndRemoveLRUWhenEmpty() {
        LRUCacheMap lruCache = new LRUCacheMap();
        Assert.assertNull((Object)lruCache.get((Object)1));
        Assert.assertNull((Object)lruCache.removeLRU());
        Assert.assertEquals((long)0L, (long)lruCache.size());
    }

    @Test
    public void testPutGetLRURemove() {
        LRUCacheMap lruCache = new LRUCacheMap();
        lruCache.put((Object)0, (Object)0);
        lruCache.put((Object)1, (Object)1);
        lruCache.put((Object)2, (Object)2);
        lruCache.put((Object)3, (Object)3);
        lruCache.put((Object)4, (Object)4);
        Assert.assertEquals((long)0L, (long)((Integer)lruCache.getLRU()).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)lruCache.getLRU()).intValue());
        lruCache.put((Object)5, (Object)5);
        Assert.assertEquals((long)2L, (long)((Integer)lruCache.getLRU()).intValue());
        Assert.assertEquals((long)3L, (long)((Integer)lruCache.getLRU()).intValue());
        Assert.assertEquals((long)4L, (long)((Integer)lruCache.getLRU()).intValue());
        Assert.assertEquals((long)0L, (long)((Integer)lruCache.getLRU()).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)lruCache.getLRU()).intValue());
        Assert.assertEquals((long)5L, (long)((Integer)lruCache.getLRU()).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)lruCache.getLRU()).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)lruCache.remove((Object)2)).intValue());
        Assert.assertEquals((long)3L, (long)((Integer)lruCache.removeLRU()).intValue());
        Assert.assertEquals((long)4L, (long)((Integer)lruCache.removeLRU()).intValue());
        Assert.assertEquals((long)0L, (long)((Integer)lruCache.removeLRU()).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)lruCache.removeLRU()).intValue());
        Assert.assertEquals((long)5L, (long)((Integer)lruCache.removeLRU()).intValue());
        Assert.assertTrue((boolean)lruCache.isEmpty());
    }

    @Test
    public void testPutGetRemoveLRU() {
        LRUCacheMap lruCache = new LRUCacheMap();
        lruCache.put((Object)0, (Object)0);
        lruCache.put((Object)1, (Object)1);
        lruCache.put((Object)2, (Object)2);
        lruCache.put((Object)3, (Object)3);
        lruCache.put((Object)4, (Object)4);
        lruCache.get((Object)1);
        Assert.assertEquals((long)0L, (long)((Integer)lruCache.removeLRU()).intValue());
        lruCache.get((Object)2);
        lruCache.put((Object)5, (Object)5);
        Assert.assertEquals((long)3L, (long)((Integer)lruCache.removeLRU()).intValue());
        Assert.assertEquals((long)4L, (long)((Integer)lruCache.removeLRU()).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)lruCache.removeLRU()).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)lruCache.removeLRU()).intValue());
        Assert.assertEquals((long)5L, (long)((Integer)lruCache.removeLRU()).intValue());
    }

    @Test
    public void testPutAndRemoveLRU() {
        int i;
        LRUCacheMap lruCache = new LRUCacheMap();
        int numEntries = 100;
        for (i = 0; i < 100; ++i) {
            lruCache.put((Object)i, (Object)i);
        }
        for (i = 0; i < 100; ++i) {
            int lru = (Integer)lruCache.removeLRU();
            Assert.assertEquals((long)i, (long)lru);
        }
        Assert.assertEquals((long)0L, (long)lruCache.size());
        Assert.assertNull((Object)lruCache.removeLRU());
    }

    @Test
    public void testPutRandomGetRemoveLRU() {
        int i;
        LRUCacheMap lruCache = new LRUCacheMap();
        Random random = new Random();
        int numEntries = 5;
        int[] expectedLruOrder = new int[5];
        for (i = 0; i < 5; ++i) {
            lruCache.put((Object)i, (Object)i);
            expectedLruOrder[i] = i;
        }
        for (i = 0; i < 50; ++i) {
            int randomKey = random.nextInt(5);
            int currentPosition = expectedLruOrder[randomKey];
            for (int j = 0; j < 5; ++j) {
                if (expectedLruOrder[j] <= currentPosition) continue;
                int n = j;
                expectedLruOrder[n] = expectedLruOrder[n] - 1;
            }
            expectedLruOrder[randomKey] = 4;
            lruCache.get((Object)randomKey);
        }
        for (i = 0; i < 5; ++i) {
            int lru = (Integer)lruCache.removeLRU();
            Assert.assertEquals((long)expectedLruOrder[lru], (long)i);
        }
        Assert.assertEquals((long)0L, (long)lruCache.size());
        Assert.assertNull((Object)lruCache.removeLRU());
    }
}

