/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.io.network.api.serialization.types.SerializationTestType;
import org.apache.flink.runtime.io.network.api.serialization.types.SerializationTestTypeFactory;
import org.apache.flink.runtime.io.network.api.serialization.types.Util;
import org.apache.flink.runtime.util.DataInputDeserializer;
import org.apache.flink.runtime.util.DataOutputSerializer;
import org.junit.Assert;
import org.junit.Test;

public class DataInputOutputSerializerTest {
    @Test
    public void testWrapAsByteBuffer() {
        SerializationTestType randomInt = Util.randomRecord(SerializationTestTypeFactory.INT);
        DataOutputSerializer serializer = new DataOutputSerializer(randomInt.length());
        MemorySegment segment = MemorySegmentFactory.allocateUnpooledSegment((int)randomInt.length());
        try {
            ByteBuffer wrapper = serializer.wrapAsByteBuffer();
            Assert.assertEquals((long)0L, (long)wrapper.position());
            Assert.assertEquals((long)0L, (long)wrapper.limit());
            randomInt.write((DataOutputView)serializer);
            Assert.assertEquals((long)0L, (long)wrapper.position());
            Assert.assertEquals((long)0L, (long)wrapper.limit());
            wrapper = serializer.wrapAsByteBuffer();
            Assert.assertEquals((long)0L, (long)wrapper.position());
            Assert.assertEquals((long)randomInt.length(), (long)wrapper.limit());
            serializer.clear();
            Assert.assertEquals((long)0L, (long)wrapper.position());
            Assert.assertEquals((long)randomInt.length(), (long)wrapper.limit());
            wrapper = serializer.wrapAsByteBuffer();
            Assert.assertEquals((long)0L, (long)wrapper.position());
            Assert.assertEquals((long)0L, (long)wrapper.limit());
            randomInt.write((DataOutputView)serializer);
            wrapper = serializer.wrapAsByteBuffer();
            segment.put(0, wrapper, randomInt.length());
            Assert.assertEquals((long)randomInt.length(), (long)wrapper.position());
            Assert.assertEquals((long)randomInt.length(), (long)wrapper.limit());
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)"Test encountered an unexpected exception.");
        }
    }

    @Test
    public void testRandomValuesWriteRead() {
        int numElements = 100000;
        ArrayDeque<SerializationTestType> reference = new ArrayDeque<SerializationTestType>();
        DataOutputSerializer serializer = new DataOutputSerializer(1);
        for (SerializationTestType value : Util.randomRecords(100000)) {
            reference.add(value);
            try {
                value.write((DataOutputView)serializer);
            }
            catch (IOException e) {
                e.printStackTrace();
                Assert.fail((String)"Test encountered an unexpected exception.");
            }
        }
        DataInputDeserializer deserializer = new DataInputDeserializer(serializer.wrapAsByteBuffer());
        for (SerializationTestType expected : reference) {
            try {
                SerializationTestType actual = (SerializationTestType)expected.getClass().newInstance();
                actual.read((DataInputView)deserializer);
                Assert.assertEquals((Object)expected, (Object)actual);
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"Test encountered an unexpected exception.");
            }
        }
        reference.clear();
    }
}

