/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskmanager;

import java.lang.reflect.Field;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.TaskInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.broadcast.BroadcastVariableManager;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptor;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.execution.librarycache.LibraryCacheManager;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.filecache.FileCache;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.network.NetworkEnvironment;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.jobgraph.tasks.StoppableTask;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.metrics.groups.TaskMetricGroup;
import org.apache.flink.runtime.taskmanager.Task;
import org.apache.flink.runtime.taskmanager.TaskManagerRuntimeInfo;
import org.apache.flink.util.SerializedValue;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import scala.concurrent.duration.FiniteDuration;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={TaskDeploymentDescriptor.class, JobID.class, FiniteDuration.class})
public class TaskStopTest {
    private Task task;

    public void doMocking(AbstractInvokable taskMock) throws Exception {
        TaskInfo taskInfoMock = (TaskInfo)Mockito.mock(TaskInfo.class);
        Mockito.when((Object)taskInfoMock.getTaskNameWithSubtasks()).thenReturn((Object)"dummyName");
        TaskDeploymentDescriptor tddMock = (TaskDeploymentDescriptor)Mockito.mock(TaskDeploymentDescriptor.class);
        Mockito.when((Object)tddMock.getTaskInfo()).thenReturn((Object)taskInfoMock);
        Mockito.when((Object)tddMock.getJobID()).thenReturn(Mockito.mock(JobID.class));
        Mockito.when((Object)tddMock.getVertexID()).thenReturn(Mockito.mock(JobVertexID.class));
        Mockito.when((Object)tddMock.getExecutionId()).thenReturn(Mockito.mock(ExecutionAttemptID.class));
        Mockito.when((Object)tddMock.getJobConfiguration()).thenReturn(Mockito.mock(Configuration.class));
        Mockito.when((Object)tddMock.getTaskConfiguration()).thenReturn(Mockito.mock(Configuration.class));
        Mockito.when((Object)tddMock.getSerializedExecutionConfig()).thenReturn(Mockito.mock(SerializedValue.class));
        Mockito.when((Object)tddMock.getInvokableClassName()).thenReturn((Object)"className");
        this.task = new Task(tddMock, (MemoryManager)Mockito.mock(MemoryManager.class), (IOManager)Mockito.mock(IOManager.class), (NetworkEnvironment)Mockito.mock(NetworkEnvironment.class), (BroadcastVariableManager)Mockito.mock(BroadcastVariableManager.class), (ActorGateway)Mockito.mock(ActorGateway.class), (ActorGateway)Mockito.mock(ActorGateway.class), (FiniteDuration)Mockito.mock(FiniteDuration.class), (LibraryCacheManager)Mockito.mock(LibraryCacheManager.class), (FileCache)Mockito.mock(FileCache.class), (TaskManagerRuntimeInfo)Mockito.mock(TaskManagerRuntimeInfo.class), (TaskMetricGroup)Mockito.mock(TaskMetricGroup.class));
        Field f = this.task.getClass().getDeclaredField("invokable");
        f.setAccessible(true);
        f.set(this.task, taskMock);
        Field f2 = this.task.getClass().getDeclaredField("executionState");
        f2.setAccessible(true);
        f2.set(this.task, ExecutionState.RUNNING);
    }

    @Test(timeout=10000L)
    public void testStopExecution() throws Exception {
        StoppableTestTask taskMock = new StoppableTestTask();
        this.doMocking(taskMock);
        this.task.stopExecution();
        while (!taskMock.stopCalled) {
            Thread.sleep(100L);
        }
    }

    @Test(expected=RuntimeException.class)
    public void testStopExecutionFail() throws Exception {
        AbstractInvokable taskMock = (AbstractInvokable)Mockito.mock(AbstractInvokable.class);
        this.doMocking(taskMock);
        this.task.stopExecution();
    }

    private static final class StoppableTestTask
    extends AbstractInvokable
    implements StoppableTask {
        public volatile boolean stopCalled = false;

        private StoppableTestTask() {
        }

        public void invoke() throws Exception {
        }

        public void stop() {
            this.stopCalled = true;
        }
    }
}

