/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.Closeable;
import java.io.IOException;
import org.apache.flink.runtime.state.AbstractCloseableHandle;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class AbstractCloseableHandleTest {
    @Test
    public void testRegisterThenClose() throws Exception {
        Closeable closeable = (Closeable)Mockito.mock(Closeable.class);
        CloseableHandle handle = new CloseableHandle();
        Assert.assertFalse((boolean)handle.isClosed());
        handle.registerCloseable(closeable);
        ((Closeable)Mockito.verify((Object)closeable, (VerificationMode)Mockito.times((int)0))).close();
        Assert.assertFalse((boolean)handle.isClosed());
        handle.close();
        ((Closeable)Mockito.verify((Object)closeable, (VerificationMode)Mockito.times((int)1))).close();
        Assert.assertTrue((boolean)handle.isClosed());
        handle.close();
        ((Closeable)Mockito.verify((Object)closeable, (VerificationMode)Mockito.times((int)1))).close();
        Assert.assertTrue((boolean)handle.isClosed());
    }

    @Test
    public void testCloseThenRegister() throws Exception {
        Closeable closeable = (Closeable)Mockito.mock(Closeable.class);
        CloseableHandle handle = new CloseableHandle();
        Assert.assertFalse((boolean)handle.isClosed());
        handle.close();
        Assert.assertTrue((boolean)handle.isClosed());
        try {
            handle.registerCloseable(closeable);
            Assert.fail((String)"this should throw an excepion");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("closed"));
        }
        ((Closeable)Mockito.verify((Object)closeable, (VerificationMode)Mockito.times((int)1))).close();
        Assert.assertTrue((boolean)handle.isClosed());
        handle.close();
        ((Closeable)Mockito.verify((Object)closeable, (VerificationMode)Mockito.times((int)1))).close();
        Assert.assertTrue((boolean)handle.isClosed());
    }

    private static final class CloseableHandle
    extends AbstractCloseableHandle {
        private static final long serialVersionUID = 1L;

        private CloseableHandle() {
        }
    }
}

