/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.testutils;

import java.io.IOException;
import org.apache.flink.util.MutableObjectIterator;

public class DelayingIterator<T>
implements MutableObjectIterator<T> {
    private final MutableObjectIterator<T> iterator;
    private final int delay;

    public DelayingIterator(MutableObjectIterator<T> iterator, int delay) {
        this.iterator = iterator;
        this.delay = delay;
    }

    public T next(T reuse) throws IOException {
        try {
            Thread.sleep(this.delay);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return (T)this.iterator.next(reuse);
    }

    public T next() throws IOException {
        try {
            Thread.sleep(this.delay);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return (T)this.iterator.next();
    }
}

