/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.sort;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.apache.flink.types.Record;
import org.apache.flink.util.MutableObjectIterator;

public class MockRecordReader
implements MutableObjectIterator<Record> {
    private final Record SENTINEL = new Record();
    private final BlockingQueue<Record> queue;

    public MockRecordReader() {
        this.queue = new ArrayBlockingQueue<Record>(32, false);
    }

    public MockRecordReader(int size) {
        this.queue = new ArrayBlockingQueue<Record>(size, false);
    }

    public Record next(Record reuse) {
        Record r = null;
        while (r == null) {
            try {
                r = this.queue.take();
            }
            catch (InterruptedException iex) {
                throw new RuntimeException("Reader was interrupted.");
            }
        }
        if (r == this.SENTINEL) {
            try {
                this.queue.put(r);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Reader was interrupted.");
            }
            return null;
        }
        r.copyTo(reuse);
        return reuse;
    }

    public Record next() {
        Record r = null;
        while (r == null) {
            try {
                r = this.queue.take();
            }
            catch (InterruptedException iex) {
                throw new RuntimeException("Reader was interrupted.");
            }
        }
        if (r == this.SENTINEL) {
            try {
                this.queue.put(r);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Reader was interrupted.");
            }
            return null;
        }
        Record result = new Record(r.getNumFields());
        r.copyTo(result);
        return result;
    }

    public void emit(Record element) throws InterruptedException {
        this.queue.put(element.createCopy());
    }

    public void close() {
        try {
            this.queue.put(this.SENTINEL);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

