/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.groups.TaskManagerJobMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskManagerMetricGroup;
import org.apache.flink.runtime.metrics.scope.TaskManagerJobScopeFormat;
import org.apache.flink.runtime.metrics.scope.TaskManagerScopeFormat;
import org.junit.Assert;
import org.junit.Test;

public class TaskManagerJobGroupTest {
    @Test
    public void testGenerateScopeDefault() {
        MetricRegistry registry = new MetricRegistry(new Configuration());
        TaskManagerMetricGroup tmGroup = new TaskManagerMetricGroup(registry, "theHostName", "test-tm-id");
        TaskManagerJobMetricGroup jmGroup = new TaskManagerJobMetricGroup(registry, tmGroup, new JobID(), "myJobName");
        Assert.assertArrayEquals((Object[])new String[]{"theHostName", "taskmanager", "test-tm-id", "myJobName"}, (Object[])jmGroup.getScopeComponents());
        Assert.assertEquals((Object)"theHostName.taskmanager.test-tm-id.myJobName.name", (Object)jmGroup.getMetricIdentifier("name"));
        registry.shutdown();
    }

    @Test
    public void testGenerateScopeCustom() {
        MetricRegistry registry = new MetricRegistry(new Configuration());
        TaskManagerScopeFormat tmFormat = new TaskManagerScopeFormat("abc");
        TaskManagerJobScopeFormat jmFormat = new TaskManagerJobScopeFormat("some-constant.<job_name>", tmFormat);
        JobID jid = new JobID();
        TaskManagerMetricGroup tmGroup = new TaskManagerMetricGroup(registry, "theHostName", "test-tm-id");
        TaskManagerJobMetricGroup jmGroup = new TaskManagerJobMetricGroup(registry, tmGroup, jmFormat, jid, "myJobName");
        Assert.assertArrayEquals((Object[])new String[]{"some-constant", "myJobName"}, (Object[])jmGroup.getScopeComponents());
        Assert.assertEquals((Object)"some-constant.myJobName.name", (Object)jmGroup.getMetricIdentifier("name"));
        registry.shutdown();
    }

    @Test
    public void testGenerateScopeCustomWildcard() {
        MetricRegistry registry = new MetricRegistry(new Configuration());
        TaskManagerScopeFormat tmFormat = new TaskManagerScopeFormat("peter.<tm_id>");
        TaskManagerJobScopeFormat jmFormat = new TaskManagerJobScopeFormat("*.some-constant.<job_id>", tmFormat);
        JobID jid = new JobID();
        TaskManagerMetricGroup tmGroup = new TaskManagerMetricGroup(registry, tmFormat, "theHostName", "test-tm-id");
        TaskManagerJobMetricGroup jmGroup = new TaskManagerJobMetricGroup(registry, tmGroup, jmFormat, jid, "myJobName");
        Assert.assertArrayEquals((Object[])new String[]{"peter", "test-tm-id", "some-constant", jid.toString()}, (Object[])jmGroup.getScopeComponents());
        Assert.assertEquals((Object)("peter.test-tm-id.some-constant." + jid + ".name"), (Object)jmGroup.getMetricIdentifier("name"));
        registry.shutdown();
    }
}

