/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager;

import java.io.File;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.jobmanager.JobManager;
import org.apache.flink.runtime.jobmanager.JobManagerMode;
import org.apache.flink.runtime.util.StartupUtils;
import org.apache.flink.shaded.com.google.common.io.Files;
import org.apache.flink.util.NetUtils;
import org.apache.flink.util.OperatingSystem;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class JobManagerStartupTest {
    private static final String DOES_NOT_EXISTS_NO_SIR = "does-not-exist-no-sir";
    private File blobStorageDirectory;

    @Before
    public void before() {
        this.blobStorageDirectory = Files.createTempDir();
        Assume.assumeTrue((!OperatingSystem.isWindows() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.blobStorageDirectory.setExecutable(true, false));
        Assert.assertTrue((boolean)this.blobStorageDirectory.setReadable(true, false));
        Assert.assertTrue((boolean)this.blobStorageDirectory.setWritable(false, false));
    }

    @After
    public void after() {
        Assert.assertTrue((boolean)this.blobStorageDirectory.delete());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=BindException.class)
    public void testStartupWithPortInUse() throws BindException {
        ServerSocket portOccupier;
        int portNum;
        try {
            portNum = NetUtils.getAvailablePort();
            portOccupier = new ServerSocket(portNum, 10, InetAddress.getByName("localhost"));
        }
        catch (Throwable t) {
            return;
        }
        try {
            JobManager.runJobManager((Configuration)new Configuration(), (JobManagerMode)JobManagerMode.CLUSTER, (String)"localhost", (int)portNum);
            Assert.fail((String)"this should throw an exception");
        }
        catch (Exception e) {
            List<Throwable> causes = StartupUtils.getExceptionCauses(e, new ArrayList<Throwable>());
            for (Throwable cause : causes) {
                if (!(cause instanceof BindException)) continue;
                throw (BindException)cause;
            }
            Assert.fail((String)"this should throw a BindException");
        }
        finally {
            try {
                portOccupier.close();
            }
            catch (Throwable throwable) {}
        }
    }

    @Test
    public void testJobManagerStartupFails() {
        int portNum;
        try {
            portNum = NetUtils.getAvailablePort();
        }
        catch (Throwable t) {
            return;
        }
        Configuration failConfig = new Configuration();
        String nonExistDirectory = new File(this.blobStorageDirectory, DOES_NOT_EXISTS_NO_SIR).getAbsolutePath();
        failConfig.setString("blob.storage.directory", nonExistDirectory);
        try {
            JobManager.runJobManager((Configuration)failConfig, (JobManagerMode)JobManagerMode.CLUSTER, (String)"localhost", (int)portNum);
            Assert.fail((String)"this should fail with an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

