/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.serialization;

import java.util.ArrayList;
import java.util.Random;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.io.network.api.serialization.AdaptiveSpanningRecordDeserializer;
import org.apache.flink.runtime.io.network.api.serialization.SpanningRecordSerializer;
import org.apache.flink.runtime.io.network.api.serialization.SpillingAdaptiveSpanningRecordDeserializer;
import org.apache.flink.runtime.io.network.api.serialization.types.IntType;
import org.apache.flink.runtime.io.network.api.serialization.types.SerializationTestType;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.io.network.serialization.types.LargeObjectType;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class LargeRecordsTest {
    @Test
    public void testHandleMixedLargeRecords() {
        try {
            int NUM_RECORDS = 99;
            int SEGMENT_SIZE = 32768;
            SpanningRecordSerializer serializer = new SpanningRecordSerializer();
            AdaptiveSpanningRecordDeserializer deserializer = new AdaptiveSpanningRecordDeserializer();
            Buffer buffer = new Buffer(MemorySegmentFactory.allocateUnpooledSegment((int)32768), (BufferRecycler)Mockito.mock(BufferRecycler.class));
            ArrayList<SerializationTestType> originalRecords = new ArrayList<SerializationTestType>();
            ArrayList<SerializationTestType> deserializedRecords = new ArrayList<SerializationTestType>();
            LargeObjectType genLarge = new LargeObjectType();
            Random rnd = new Random();
            for (int i = 0; i < 99; ++i) {
                if (i % 2 == 0) {
                    originalRecords.add(new IntType(42));
                    deserializedRecords.add(new IntType());
                    continue;
                }
                originalRecords.add(genLarge.getRandom(rnd));
                deserializedRecords.add(new LargeObjectType());
            }
            serializer.setNextBuffer(buffer);
            int numRecordsDeserialized = 0;
            for (SerializationTestType record : originalRecords) {
                SerializationTestType next;
                if (!serializer.addRecord((IOReadableWritable)record).isFullBuffer()) continue;
                deserializer.setNextMemorySegment(serializer.getCurrentBuffer().getMemorySegment(), 32768);
                while (numRecordsDeserialized < deserializedRecords.size() && deserializer.getNextRecord((IOReadableWritable)(next = (SerializationTestType)deserializedRecords.get(numRecordsDeserialized))).isFullRecord()) {
                    Assert.assertEquals(originalRecords.get(numRecordsDeserialized), (Object)next);
                    ++numRecordsDeserialized;
                }
                while (serializer.setNextBuffer(buffer).isFullBuffer()) {
                    deserializer.setNextMemorySegment(serializer.getCurrentBuffer().getMemorySegment(), 32768);
                }
                while (numRecordsDeserialized < deserializedRecords.size() && deserializer.getNextRecord((IOReadableWritable)(next = (SerializationTestType)deserializedRecords.get(numRecordsDeserialized))).isFullRecord()) {
                    Assert.assertEquals(originalRecords.get(numRecordsDeserialized), (Object)next);
                    ++numRecordsDeserialized;
                }
            }
            Buffer last = serializer.getCurrentBuffer();
            deserializer.setNextMemorySegment(last.getMemorySegment(), last.getSize());
            serializer.clear();
            while (numRecordsDeserialized < deserializedRecords.size()) {
                SerializationTestType next = (SerializationTestType)deserializedRecords.get(numRecordsDeserialized);
                Assert.assertTrue((boolean)deserializer.getNextRecord((IOReadableWritable)next).isFullRecord());
                Assert.assertEquals(originalRecords.get(numRecordsDeserialized), (Object)next);
                ++numRecordsDeserialized;
            }
            Assert.assertFalse((boolean)serializer.hasData());
            Assert.assertFalse((boolean)deserializer.hasUnfinishedData());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testHandleMixedLargeRecordsSpillingAdaptiveSerializer() {
        try {
            int NUM_RECORDS = 99;
            int SEGMENT_SIZE = 32768;
            SpanningRecordSerializer serializer = new SpanningRecordSerializer();
            SpillingAdaptiveSpanningRecordDeserializer deserializer = new SpillingAdaptiveSpanningRecordDeserializer(new String[]{System.getProperty("java.io.tmpdir")});
            Buffer buffer = new Buffer(MemorySegmentFactory.allocateUnpooledSegment((int)32768), (BufferRecycler)Mockito.mock(BufferRecycler.class));
            ArrayList<SerializationTestType> originalRecords = new ArrayList<SerializationTestType>();
            ArrayList<SerializationTestType> deserializedRecords = new ArrayList<SerializationTestType>();
            LargeObjectType genLarge = new LargeObjectType();
            Random rnd = new Random();
            for (int i = 0; i < 99; ++i) {
                if (i % 2 == 0) {
                    originalRecords.add(new IntType(42));
                    deserializedRecords.add(new IntType());
                    continue;
                }
                originalRecords.add(genLarge.getRandom(rnd));
                deserializedRecords.add(new LargeObjectType());
            }
            serializer.setNextBuffer(buffer);
            int numRecordsDeserialized = 0;
            for (SerializationTestType record : originalRecords) {
                SerializationTestType next;
                if (!serializer.addRecord((IOReadableWritable)record).isFullBuffer()) continue;
                deserializer.setNextMemorySegment(serializer.getCurrentBuffer().getMemorySegment(), 32768);
                while (numRecordsDeserialized < deserializedRecords.size() && deserializer.getNextRecord((IOReadableWritable)(next = (SerializationTestType)deserializedRecords.get(numRecordsDeserialized))).isFullRecord()) {
                    Assert.assertEquals(originalRecords.get(numRecordsDeserialized), (Object)next);
                    ++numRecordsDeserialized;
                }
                while (serializer.setNextBuffer(buffer).isFullBuffer()) {
                    deserializer.setNextMemorySegment(serializer.getCurrentBuffer().getMemorySegment(), 32768);
                }
                while (numRecordsDeserialized < deserializedRecords.size() && deserializer.getNextRecord((IOReadableWritable)(next = (SerializationTestType)deserializedRecords.get(numRecordsDeserialized))).isFullRecord()) {
                    Assert.assertEquals(originalRecords.get(numRecordsDeserialized), (Object)next);
                    ++numRecordsDeserialized;
                }
            }
            Buffer last = serializer.getCurrentBuffer();
            deserializer.setNextMemorySegment(last.getMemorySegment(), last.getSize());
            serializer.clear();
            while (numRecordsDeserialized < deserializedRecords.size()) {
                SerializationTestType next = (SerializationTestType)deserializedRecords.get(numRecordsDeserialized);
                Assert.assertTrue((boolean)deserializer.getNextRecord((IOReadableWritable)next).isFullRecord());
                Assert.assertEquals(originalRecords.get(numRecordsDeserialized), (Object)next);
                ++numRecordsDeserialized;
            }
            Assert.assertFalse((boolean)serializer.hasData());
            Assert.assertFalse((boolean)deserializer.hasUnfinishedData());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

