/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.io.network.netty.PartitionStateChecker;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGateTest;
import org.apache.flink.runtime.io.network.partition.consumer.TestInputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.UnionInputGate;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.metrics.groups.IOMetricGroup;
import org.apache.flink.runtime.operators.testutils.UnregisteredTaskMetricsGroup;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class UnionInputGateTest {
    @Test(timeout=120000L)
    public void testBasicGetNextLogic() throws Exception {
        String testTaskName = "Test Task";
        SingleInputGate ig1 = new SingleInputGate("Test Task", new JobID(), new ExecutionAttemptID(), new IntermediateDataSetID(), 0, 3, (PartitionStateChecker)Mockito.mock(PartitionStateChecker.class), (IOMetricGroup)new UnregisteredTaskMetricsGroup.DummyIOMetricGroup());
        SingleInputGate ig2 = new SingleInputGate("Test Task", new JobID(), new ExecutionAttemptID(), new IntermediateDataSetID(), 0, 5, (PartitionStateChecker)Mockito.mock(PartitionStateChecker.class), (IOMetricGroup)new UnregisteredTaskMetricsGroup.DummyIOMetricGroup());
        UnionInputGate union = new UnionInputGate((InputGate[])new SingleInputGate[]{ig1, ig2});
        Assert.assertEquals((long)(ig1.getNumberOfInputChannels() + ig2.getNumberOfInputChannels()), (long)union.getNumberOfInputChannels());
        TestInputChannel[][] inputChannels = new TestInputChannel[][]{TestInputChannel.createInputChannels(ig1, 3), TestInputChannel.createInputChannels(ig2, 5)};
        inputChannels[0][0].readBuffer();
        inputChannels[0][0].readEndOfPartitionEvent();
        inputChannels[1][2].readBuffer();
        inputChannels[1][2].readEndOfPartitionEvent();
        inputChannels[1][0].readBuffer();
        inputChannels[1][1].readBuffer();
        inputChannels[0][1].readBuffer();
        inputChannels[1][3].readBuffer();
        inputChannels[0][1].readEndOfPartitionEvent();
        inputChannels[1][3].readEndOfPartitionEvent();
        inputChannels[0][2].readBuffer();
        inputChannels[0][2].readEndOfPartitionEvent();
        inputChannels[1][4].readBuffer();
        inputChannels[1][4].readEndOfPartitionEvent();
        inputChannels[1][1].readEndOfPartitionEvent();
        inputChannels[1][0].readEndOfPartitionEvent();
        SingleInputGateTest.verifyBufferOrEvent((InputGate)union, true, 0);
        SingleInputGateTest.verifyBufferOrEvent((InputGate)union, false, 0);
        SingleInputGateTest.verifyBufferOrEvent((InputGate)union, true, 5);
        SingleInputGateTest.verifyBufferOrEvent((InputGate)union, false, 5);
        SingleInputGateTest.verifyBufferOrEvent((InputGate)union, true, 3);
        SingleInputGateTest.verifyBufferOrEvent((InputGate)union, true, 4);
        SingleInputGateTest.verifyBufferOrEvent((InputGate)union, true, 1);
        SingleInputGateTest.verifyBufferOrEvent((InputGate)union, true, 6);
        SingleInputGateTest.verifyBufferOrEvent((InputGate)union, false, 1);
        SingleInputGateTest.verifyBufferOrEvent((InputGate)union, false, 6);
        SingleInputGateTest.verifyBufferOrEvent((InputGate)union, true, 2);
        SingleInputGateTest.verifyBufferOrEvent((InputGate)union, false, 2);
        SingleInputGateTest.verifyBufferOrEvent((InputGate)union, true, 7);
        SingleInputGateTest.verifyBufferOrEvent((InputGate)union, false, 7);
        SingleInputGateTest.verifyBufferOrEvent((InputGate)union, false, 4);
        SingleInputGateTest.verifyBufferOrEvent((InputGate)union, false, 3);
        Assert.assertTrue((boolean)union.isFinished());
        Assert.assertNull((Object)union.getNextBufferOrEvent());
    }
}

