/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import java.io.IOException;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.network.api.EndOfPartitionEvent;
import org.apache.flink.runtime.io.network.api.serialization.EventSerializer;
import org.apache.flink.runtime.io.network.api.serialization.RecordSerializer;
import org.apache.flink.runtime.io.network.api.serialization.SpanningRecordSerializer;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.io.network.partition.consumer.TestInputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.TestSingleInputGate;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.MutableObjectIterator;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class IteratorWrappingTestSingleInputGate<T extends IOReadableWritable>
extends TestSingleInputGate {
    private final TestInputChannel inputChannel;
    private final int bufferSize;
    private MutableObjectIterator<T> inputIterator;
    private RecordSerializer<T> serializer;
    private final T reuse;

    public IteratorWrappingTestSingleInputGate(int bufferSize, Class<T> recordType, MutableObjectIterator<T> iterator) throws IOException, InterruptedException {
        super(1, false);
        this.inputChannel = new TestInputChannel(this.inputGate, 0);
        this.bufferSize = bufferSize;
        this.reuse = (IOReadableWritable)InstantiationUtil.instantiate(recordType);
        this.wrapIterator(iterator);
    }

    private IteratorWrappingTestSingleInputGate<T> wrapIterator(MutableObjectIterator<T> iterator) throws IOException, InterruptedException {
        this.inputIterator = iterator;
        this.serializer = new SpanningRecordSerializer();
        Answer<Buffer> answer = new Answer<Buffer>(){

            public Buffer answer(InvocationOnMock invocationOnMock) throws Throwable {
                if (IteratorWrappingTestSingleInputGate.this.inputIterator.next((Object)IteratorWrappingTestSingleInputGate.this.reuse) != null) {
                    Buffer buffer = new Buffer(MemorySegmentFactory.allocateUnpooledSegment((int)IteratorWrappingTestSingleInputGate.this.bufferSize), (BufferRecycler)Mockito.mock(BufferRecycler.class));
                    IteratorWrappingTestSingleInputGate.this.serializer.setNextBuffer(buffer);
                    IteratorWrappingTestSingleInputGate.this.serializer.addRecord(IteratorWrappingTestSingleInputGate.this.reuse);
                    IteratorWrappingTestSingleInputGate.this.inputGate.onAvailableBuffer(IteratorWrappingTestSingleInputGate.this.inputChannel.getInputChannel());
                    return IteratorWrappingTestSingleInputGate.this.serializer.getCurrentBuffer();
                }
                Mockito.when((Object)IteratorWrappingTestSingleInputGate.this.inputChannel.getInputChannel().isReleased()).thenReturn((Object)true);
                return EventSerializer.toBuffer((AbstractEvent)EndOfPartitionEvent.INSTANCE);
            }
        };
        Mockito.when((Object)this.inputChannel.getInputChannel().getNextBuffer()).thenAnswer((Answer)answer);
        this.inputGate.setInputChannel(new IntermediateResultPartitionID(), this.inputChannel.getInputChannel());
        return this;
    }

    public IteratorWrappingTestSingleInputGate<T> read() {
        this.inputGate.onAvailableBuffer(this.inputChannel.getInputChannel());
        return this;
    }
}

