/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import java.io.IOException;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.runtime.event.TaskEvent;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import scala.Tuple2;

public class InputChannelTest {
    @Test
    public void testExponentialBackoff() throws Exception {
        InputChannel ch = this.createInputChannel(500, 4000);
        Assert.assertEquals((long)0L, (long)ch.getCurrentBackoff());
        Assert.assertTrue((boolean)ch.increaseBackoff());
        Assert.assertEquals((long)500L, (long)ch.getCurrentBackoff());
        Assert.assertTrue((boolean)ch.increaseBackoff());
        Assert.assertEquals((long)1000L, (long)ch.getCurrentBackoff());
        Assert.assertTrue((boolean)ch.increaseBackoff());
        Assert.assertEquals((long)2000L, (long)ch.getCurrentBackoff());
        Assert.assertTrue((boolean)ch.increaseBackoff());
        Assert.assertEquals((long)4000L, (long)ch.getCurrentBackoff());
        Assert.assertFalse((boolean)ch.increaseBackoff());
        Assert.assertEquals((long)4000L, (long)ch.getCurrentBackoff());
    }

    @Test
    public void testExponentialBackoffCappedAtMax() throws Exception {
        InputChannel ch = this.createInputChannel(500, 3000);
        Assert.assertEquals((long)0L, (long)ch.getCurrentBackoff());
        Assert.assertTrue((boolean)ch.increaseBackoff());
        Assert.assertEquals((long)500L, (long)ch.getCurrentBackoff());
        Assert.assertTrue((boolean)ch.increaseBackoff());
        Assert.assertEquals((long)1000L, (long)ch.getCurrentBackoff());
        Assert.assertTrue((boolean)ch.increaseBackoff());
        Assert.assertEquals((long)2000L, (long)ch.getCurrentBackoff());
        Assert.assertTrue((boolean)ch.increaseBackoff());
        Assert.assertEquals((long)3000L, (long)ch.getCurrentBackoff());
        Assert.assertFalse((boolean)ch.increaseBackoff());
        Assert.assertEquals((long)3000L, (long)ch.getCurrentBackoff());
    }

    @Test
    public void testExponentialBackoffSingle() throws Exception {
        InputChannel ch = this.createInputChannel(500, 500);
        Assert.assertEquals((long)0L, (long)ch.getCurrentBackoff());
        Assert.assertTrue((boolean)ch.increaseBackoff());
        Assert.assertEquals((long)500L, (long)ch.getCurrentBackoff());
        Assert.assertFalse((boolean)ch.increaseBackoff());
        Assert.assertEquals((long)500L, (long)ch.getCurrentBackoff());
    }

    @Test
    public void testExponentialNoBackoff() throws Exception {
        InputChannel ch = this.createInputChannel(0, 0);
        Assert.assertEquals((long)0L, (long)ch.getCurrentBackoff());
        Assert.assertFalse((boolean)ch.increaseBackoff());
        Assert.assertEquals((long)0L, (long)ch.getCurrentBackoff());
    }

    private InputChannel createInputChannel(int initialBackoff, int maxBackoff) {
        return new MockInputChannel((SingleInputGate)Mockito.mock(SingleInputGate.class), 0, new ResultPartitionID(), new Tuple2((Object)initialBackoff, (Object)maxBackoff));
    }

    private static class MockInputChannel
    extends InputChannel {
        private MockInputChannel(SingleInputGate inputGate, int channelIndex, ResultPartitionID partitionId, Tuple2<Integer, Integer> initialAndMaxBackoff) {
            super(inputGate, channelIndex, partitionId, initialAndMaxBackoff, (Counter)new SimpleCounter());
        }

        void requestSubpartition(int subpartitionIndex) throws IOException, InterruptedException {
        }

        Buffer getNextBuffer() throws IOException, InterruptedException {
            return null;
        }

        void sendTaskEvent(TaskEvent event) throws IOException {
        }

        boolean isReleased() {
            return false;
        }

        void notifySubpartitionConsumed() throws IOException {
        }

        void releaseAllResources() throws IOException {
        }
    }
}

