/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.serialization.types;

import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.io.network.api.serialization.types.SerializationTestType;

public class ByteArrayType
implements SerializationTestType {
    private static final int MAX_LEN = 7680;
    private byte[] data;

    public ByteArrayType() {
        this.data = new byte[0];
    }

    public ByteArrayType(byte[] data) {
        this.data = data;
    }

    @Override
    public ByteArrayType getRandom(Random rnd) {
        int len = rnd.nextInt(7680) + 1;
        byte[] data = new byte[len];
        rnd.nextBytes(data);
        return new ByteArrayType(data);
    }

    @Override
    public int length() {
        return this.data.length + 4;
    }

    public void write(DataOutputView out) throws IOException {
        out.writeInt(this.data.length);
        out.write(this.data);
    }

    public void read(DataInputView in) throws IOException {
        int len = in.readInt();
        this.data = new byte[len];
        in.readFully(this.data);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ByteArrayType) {
            ByteArrayType other = (ByteArrayType)obj;
            return Arrays.equals(this.data, other.data);
        }
        return false;
    }
}

