/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.reader;

import java.io.IOException;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.accumulators.AccumulatorRegistry;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.event.TaskEvent;
import org.apache.flink.runtime.io.network.api.EndOfPartitionEvent;
import org.apache.flink.runtime.io.network.api.EndOfSuperstepEvent;
import org.apache.flink.runtime.io.network.api.reader.AbstractReader;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.runtime.util.event.EventListener;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class AbstractReaderTest {
    @Test
    public void testTaskEvent() throws Exception {
        MockReader reader = new MockReader(this.createInputGate(1));
        EventListener listener1 = (EventListener)Mockito.mock(EventListener.class);
        EventListener listener2 = (EventListener)Mockito.mock(EventListener.class);
        EventListener listener3 = (EventListener)Mockito.mock(EventListener.class);
        reader.registerTaskEventListener(listener1, TestTaskEvent1.class);
        reader.registerTaskEventListener(listener2, TestTaskEvent2.class);
        reader.registerTaskEventListener(listener3, TaskEvent.class);
        reader.handleEvent((AbstractEvent)new TestTaskEvent1());
        reader.handleEvent((AbstractEvent)new TestTaskEvent2());
        ((EventListener)Mockito.verify((Object)listener1, (VerificationMode)Mockito.times((int)1))).onEvent(Matchers.any(TaskEvent.class));
        ((EventListener)Mockito.verify((Object)listener2, (VerificationMode)Mockito.times((int)1))).onEvent(Matchers.any(TaskEvent.class));
        ((EventListener)Mockito.verify((Object)listener3, (VerificationMode)Mockito.times((int)0))).onEvent(Matchers.any(TaskEvent.class));
    }

    @Test
    public void testEndOfPartitionEvent() throws Exception {
        MockReader reader = new MockReader(this.createInputGate(1));
        Assert.assertTrue((boolean)reader.handleEvent((AbstractEvent)EndOfPartitionEvent.INSTANCE));
    }

    @Test
    public void testExceptionsNonIterativeReader() throws Exception {
        MockReader reader = new MockReader(this.createInputGate(4));
        Assert.assertFalse((boolean)reader.hasReachedEndOfSuperstep());
        try {
            reader.startNextSuperstep();
            Assert.fail((String)"Did not throw expected exception when starting next superstep with non-iterative reader.");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            reader.handleEvent((AbstractEvent)EndOfSuperstepEvent.INSTANCE);
            Assert.fail((String)"Did not throw expected exception when handling end of superstep event with non-iterative reader.");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Test
    public void testEndOfSuperstepEventLogic() throws IOException {
        int numberOfInputChannels = 4;
        MockReader reader = new MockReader(this.createInputGate(4));
        reader.setIterativeReader();
        try {
            reader.startNextSuperstep();
            Assert.fail((String)"Did not throw expected exception when starting next superstep before receiving all end of superstep events.");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        EndOfSuperstepEvent eos = EndOfSuperstepEvent.INSTANCE;
        for (int i = 0; i < 3; ++i) {
            Assert.assertFalse((boolean)reader.handleEvent((AbstractEvent)eos));
            Assert.assertFalse((boolean)reader.hasReachedEndOfSuperstep());
        }
        Assert.assertTrue((boolean)reader.handleEvent((AbstractEvent)eos));
        Assert.assertTrue((boolean)reader.hasReachedEndOfSuperstep());
        try {
            reader.handleEvent((AbstractEvent)eos);
            Assert.fail((String)"Did not throw expected exception when receiving too many end of superstep events.");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        reader.startNextSuperstep();
        Assert.assertFalse((boolean)reader.hasReachedEndOfSuperstep());
    }

    private InputGate createInputGate(int numberOfInputChannels) {
        InputGate inputGate = (InputGate)Mockito.mock(InputGate.class);
        Mockito.when((Object)inputGate.getNumberOfInputChannels()).thenReturn((Object)numberOfInputChannels);
        return inputGate;
    }

    private static class MockReader
    extends AbstractReader {
        protected MockReader(InputGate inputGate) {
            super(inputGate);
        }

        public void setReporter(AccumulatorRegistry.Reporter reporter) {
        }
    }

    private static class TestTaskEvent2
    extends TaskEvent {
        private TestTaskEvent2() {
        }

        public void write(DataOutputView out) throws IOException {
        }

        public void read(DataInputView in) throws IOException {
        }
    }

    private static class TestTaskEvent1
    extends TaskEvent {
        private TestTaskEvent1() {
        }

        public void write(DataOutputView out) throws IOException {
        }

        public void read(DataInputView in) throws IOException {
        }
    }
}

