/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.instance;

import java.io.Serializable;
import java.net.InetAddress;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.runtime.instance.InstanceConnectionInfo;
import org.apache.flink.util.InstantiationUtil;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class InstanceConnectionInfoTest {
    @Test
    public void testEqualsHashAndCompareTo() {
        try {
            InetAddress address1 = (InetAddress)Mockito.mock(InetAddress.class);
            Mockito.when((Object)address1.getCanonicalHostName()).thenReturn((Object)"localhost");
            Mockito.when((Object)address1.getHostName()).thenReturn((Object)"localhost");
            Mockito.when((Object)address1.getHostAddress()).thenReturn((Object)"127.0.0.1");
            Mockito.when((Object)address1.getAddress()).thenReturn((Object)new byte[]{127, 0, 0, 1});
            InetAddress address2 = (InetAddress)Mockito.mock(InetAddress.class);
            Mockito.when((Object)address2.getCanonicalHostName()).thenReturn((Object)"testhost1");
            Mockito.when((Object)address2.getHostName()).thenReturn((Object)"testhost1");
            Mockito.when((Object)address2.getHostAddress()).thenReturn((Object)"0.0.0.0");
            Mockito.when((Object)address2.getAddress()).thenReturn((Object)new byte[]{0, 0, 0, 0});
            InetAddress address3 = (InetAddress)Mockito.mock(InetAddress.class);
            Mockito.when((Object)address3.getCanonicalHostName()).thenReturn((Object)"testhost2");
            Mockito.when((Object)address3.getHostName()).thenReturn((Object)"testhost2");
            Mockito.when((Object)address3.getHostAddress()).thenReturn((Object)"192.168.0.1");
            Mockito.when((Object)address3.getAddress()).thenReturn((Object)new byte[]{-64, -88, 0, 1});
            InstanceConnectionInfo one = new InstanceConnectionInfo(address1, 19871);
            InstanceConnectionInfo two = new InstanceConnectionInfo(address2, 19871);
            InstanceConnectionInfo three = new InstanceConnectionInfo(address3, 10871);
            InstanceConnectionInfo four = new InstanceConnectionInfo(address1, 19871);
            Assert.assertTrue((boolean)one.equals((Object)four));
            Assert.assertTrue((!one.equals((Object)two) ? 1 : 0) != 0);
            Assert.assertTrue((!one.equals((Object)three) ? 1 : 0) != 0);
            Assert.assertTrue((!two.equals((Object)three) ? 1 : 0) != 0);
            Assert.assertTrue((!three.equals((Object)four) ? 1 : 0) != 0);
            Assert.assertTrue((one.compareTo(four) == 0 ? 1 : 0) != 0);
            Assert.assertTrue((four.compareTo(one) == 0 ? 1 : 0) != 0);
            Assert.assertTrue((one.compareTo(two) != 0 ? 1 : 0) != 0);
            Assert.assertTrue((one.compareTo(three) != 0 ? 1 : 0) != 0);
            Assert.assertTrue((two.compareTo(three) != 0 ? 1 : 0) != 0);
            Assert.assertTrue((three.compareTo(four) != 0 ? 1 : 0) != 0);
            int val = one.compareTo(two);
            Assert.assertTrue((two.compareTo(one) == -val ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSerialization() {
        try {
            InstanceConnectionInfo original = new InstanceConnectionInfo(InetAddress.getByName("1.2.3.4"), 8888);
            InstanceConnectionInfo copy = (InstanceConnectionInfo)InstantiationUtil.createCopyWritable((IOReadableWritable)original);
            Assert.assertEquals((Object)original, (Object)copy);
            InstanceConnectionInfo serCopy = (InstanceConnectionInfo)InstantiationUtil.clone((Serializable)original);
            Assert.assertEquals((Object)original, (Object)serCopy);
            original = new InstanceConnectionInfo(InetAddress.getByName("127.0.0.1"), 19871);
            original.getFQDNHostname();
            copy = (InstanceConnectionInfo)InstantiationUtil.createCopyWritable((IOReadableWritable)original);
            Assert.assertEquals((Object)original, (Object)copy);
            serCopy = (InstanceConnectionInfo)InstantiationUtil.clone((Serializable)original);
            Assert.assertEquals((Object)original, (Object)serCopy);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetFQDNHostname() {
        try {
            InstanceConnectionInfo info1 = new InstanceConnectionInfo(InetAddress.getByName("127.0.0.1"), 19871);
            Assert.assertNotNull((Object)info1.getFQDNHostname());
            InstanceConnectionInfo info2 = new InstanceConnectionInfo(InetAddress.getByName("1.2.3.4"), 8888);
            Assert.assertNotNull((Object)info2.getFQDNHostname());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetHostname0() {
        try {
            InetAddress address = (InetAddress)Mockito.mock(InetAddress.class);
            Mockito.when((Object)address.getCanonicalHostName()).thenReturn((Object)"worker2.cluster.mycompany.com");
            Mockito.when((Object)address.getHostName()).thenReturn((Object)"worker2.cluster.mycompany.com");
            Mockito.when((Object)address.getHostAddress()).thenReturn((Object)"127.0.0.1");
            InstanceConnectionInfo info = new InstanceConnectionInfo(address, 19871);
            Assert.assertEquals((Object)"worker2", (Object)info.getHostname());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetHostname1() {
        try {
            InetAddress address = (InetAddress)Mockito.mock(InetAddress.class);
            Mockito.when((Object)address.getCanonicalHostName()).thenReturn((Object)"worker10");
            Mockito.when((Object)address.getHostName()).thenReturn((Object)"worker10");
            Mockito.when((Object)address.getHostAddress()).thenReturn((Object)"127.0.0.1");
            InstanceConnectionInfo info = new InstanceConnectionInfo(address, 19871);
            Assert.assertEquals((Object)"worker10", (Object)info.getHostname());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetHostname2() {
        try {
            String addressString = "192.168.254.254";
            InetAddress address = (InetAddress)Mockito.mock(InetAddress.class);
            Mockito.when((Object)address.getCanonicalHostName()).thenReturn((Object)"192.168.254.254");
            Mockito.when((Object)address.getHostName()).thenReturn((Object)"192.168.254.254");
            Mockito.when((Object)address.getHostAddress()).thenReturn((Object)"192.168.254.254");
            Mockito.when((Object)address.getAddress()).thenReturn((Object)new byte[]{-64, -88, -2, -2});
            InstanceConnectionInfo info = new InstanceConnectionInfo(address, 54152);
            Assert.assertNotNull((Object)info.getFQDNHostname());
            Assert.assertTrue((boolean)info.getFQDNHostname().equals("192.168.254.254"));
            Assert.assertNotNull((Object)info.getHostname());
            Assert.assertTrue((boolean)info.getHostname().equals("192.168.254.254"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

