/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.execution.librarycache;

import java.io.File;
import java.io.FileInputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobCache;
import org.apache.flink.runtime.blob.BlobClient;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobService;
import org.apache.flink.runtime.execution.librarycache.BlobLibraryCacheManager;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class BlobLibraryCacheRecoveryITCase {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRecoveryRegisterAndDownload() throws Exception {
        Random rand = new Random();
        BlobServer[] server = new BlobServer[2];
        InetSocketAddress[] serverAddress = new InetSocketAddress[2];
        BlobLibraryCacheManager[] libServer = new BlobLibraryCacheManager[2];
        BlobCache cache = null;
        BlobLibraryCacheManager libCache = null;
        try {
            int i;
            BlobServer[] config = new Configuration();
            config.setString("recovery.mode", "ZOOKEEPER");
            config.setString("state.backend", "FILESYSTEM");
            config.setString("recovery.zookeeper.storageDir", this.temporaryFolder.getRoot().getAbsolutePath());
            for (int i2 = 0; i2 < server.length; ++i2) {
                server[i2] = new BlobServer((Configuration)config);
                serverAddress[i2] = new InetSocketAddress("localhost", server[i2].getPort());
                libServer[i2] = new BlobLibraryCacheManager((BlobService)server[i2], 3600000L);
            }
            byte[] expected = new byte[1024];
            rand.nextBytes(expected);
            ArrayList<BlobKey> keys = new ArrayList<BlobKey>(2);
            try (BlobClient client = new BlobClient(serverAddress[0]);){
                keys.add(client.put(expected));
                keys.add(client.put(expected, 32, 256));
            }
            cache = new BlobCache(serverAddress[0], (Configuration)config);
            libCache = new BlobLibraryCacheManager((BlobService)cache, 3600000L);
            JobID jobId = new JobID();
            ExecutionAttemptID executionId = new ExecutionAttemptID();
            libServer[0].registerTask(jobId, executionId, keys, Collections.emptyList());
            File f = libCache.getFile((BlobKey)keys.get(0));
            Assert.assertEquals((long)expected.length, (long)f.length());
            try (FileInputStream fis = new FileInputStream(f);){
                for (i = 0; i < expected.length && fis.available() > 0; ++i) {
                    Assert.assertEquals((long)expected[i], (long)((byte)fis.read()));
                }
                Assert.assertEquals((long)0L, (long)fis.available());
            }
            cache.shutdown();
            libCache.shutdown();
            cache = new BlobCache(serverAddress[1], (Configuration)config);
            libCache = new BlobLibraryCacheManager((BlobService)cache, 3600000L);
            f = libCache.getFile((BlobKey)keys.get(0));
            Assert.assertEquals((long)expected.length, (long)f.length());
            fis = new FileInputStream(f);
            var14_21 = null;
            try {
                for (i = 0; i < expected.length && fis.available() > 0; ++i) {
                    Assert.assertEquals((long)expected[i], (long)((byte)fis.read()));
                }
                Assert.assertEquals((long)0L, (long)fis.available());
            }
            catch (Throwable i3) {
                var14_21 = i3;
                throw i3;
            }
            finally {
                if (fis != null) {
                    if (var14_21 != null) {
                        try {
                            fis.close();
                        }
                        catch (Throwable i3) {
                            var14_21.addSuppressed(i3);
                        }
                    } else {
                        fis.close();
                    }
                }
            }
            f = libCache.getFile((BlobKey)keys.get(1));
            Assert.assertEquals((long)256L, (long)f.length());
            fis = new FileInputStream(f);
            var14_21 = null;
            try {
                for (int i4 = 0; i4 < 256 && fis.available() > 0; ++i4) {
                    Assert.assertEquals((long)expected[32 + i4], (long)((byte)fis.read()));
                }
                Assert.assertEquals((long)0L, (long)fis.available());
            }
            catch (Throwable throwable) {
                var14_21 = throwable;
                throw throwable;
            }
            finally {
                if (fis != null) {
                    if (var14_21 != null) {
                        try {
                            fis.close();
                        }
                        catch (Throwable throwable) {
                            var14_21.addSuppressed(throwable);
                        }
                    } else {
                        fis.close();
                    }
                }
            }
            var14_21 = null;
            try (BlobClient client = new BlobClient(serverAddress[1]);){
                client.delete((BlobKey)keys.get(0));
                client.delete((BlobKey)keys.get(1));
            }
            catch (Throwable throwable) {
                var14_21 = throwable;
                throw throwable;
            }
        }
        finally {
            for (BlobServer s : server) {
                if (s == null) continue;
                s.shutdown();
            }
            if (cache != null) {
                cache.shutdown();
            }
            if (libCache != null) {
                libCache.shutdown();
            }
        }
        Object[] recoveryFiles = this.temporaryFolder.getRoot().listFiles();
        Assert.assertEquals((String)("Unclean state backend: " + Arrays.toString(recoveryFiles)), (long)0L, (long)recoveryFiles.length);
    }
}

