/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.deployment;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptor;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.operators.BatchTask;
import org.apache.flink.util.SerializedValue;
import org.junit.Assert;
import org.junit.Test;

public class TaskDeploymentDescriptorTest {
    @Test
    public void testSerialization() {
        try {
            JobID jobID = new JobID();
            JobVertexID vertexID = new JobVertexID();
            ExecutionAttemptID execId = new ExecutionAttemptID();
            String jobName = "job name";
            String taskName = "task name";
            boolean indexInSubtaskGroup = false;
            boolean currentNumberOfSubtasks = true;
            boolean attemptNumber = false;
            Configuration jobConfiguration = new Configuration();
            Configuration taskConfiguration = new Configuration();
            Class<BatchTask> invokableClass = BatchTask.class;
            ArrayList producedResults = new ArrayList(0);
            ArrayList inputGates = new ArrayList(0);
            ArrayList requiredJars = new ArrayList(0);
            ArrayList requiredClasspaths = new ArrayList(0);
            SerializedValue executionConfig = new SerializedValue((Object)new ExecutionConfig());
            TaskDeploymentDescriptor orig = new TaskDeploymentDescriptor(jobID, "job name", vertexID, execId, executionConfig, "task name", 0, 1, 0, jobConfiguration, taskConfiguration, invokableClass.getName(), producedResults, inputGates, requiredJars, requiredClasspaths, 47);
            TaskDeploymentDescriptor copy = (TaskDeploymentDescriptor)CommonTestUtils.createCopySerializable((Serializable)orig);
            Assert.assertFalse((orig.getJobID() == copy.getJobID() ? 1 : 0) != 0);
            Assert.assertFalse((orig.getVertexID() == copy.getVertexID() ? 1 : 0) != 0);
            Assert.assertFalse((orig.getTaskName() == copy.getTaskName() ? 1 : 0) != 0);
            Assert.assertFalse((orig.getJobConfiguration() == copy.getJobConfiguration() ? 1 : 0) != 0);
            Assert.assertFalse((orig.getTaskConfiguration() == copy.getTaskConfiguration() ? 1 : 0) != 0);
            Assert.assertEquals((Object)orig.getJobID(), (Object)copy.getJobID());
            Assert.assertEquals((Object)orig.getVertexID(), (Object)copy.getVertexID());
            Assert.assertEquals((Object)orig.getTaskName(), (Object)copy.getTaskName());
            Assert.assertEquals((long)orig.getIndexInSubtaskGroup(), (long)copy.getIndexInSubtaskGroup());
            Assert.assertEquals((long)orig.getNumberOfSubtasks(), (long)copy.getNumberOfSubtasks());
            Assert.assertEquals((long)orig.getAttemptNumber(), (long)copy.getAttemptNumber());
            Assert.assertEquals((Object)orig.getProducedPartitions(), (Object)copy.getProducedPartitions());
            Assert.assertEquals((Object)orig.getInputGates(), (Object)copy.getInputGates());
            Assert.assertEquals((Object)orig.getSerializedExecutionConfig(), (Object)copy.getSerializedExecutionConfig());
            Assert.assertEquals((Object)orig.getRequiredJarFiles(), (Object)copy.getRequiredJarFiles());
            Assert.assertEquals((Object)orig.getRequiredClasspaths(), (Object)copy.getRequiredClasspaths());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

