/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.clusterframework.BootstrapTools;
import org.junit.Assert;
import org.junit.Test;

public class BootstrapToolsTest {
    @Test
    public void testSubstituteConfigKey() {
        String deprecatedKey1 = "deprecated-key";
        String deprecatedKey2 = "another-out_of-date_key";
        String deprecatedKey3 = "yet-one-more";
        String designatedKey1 = "newkey1";
        String designatedKey2 = "newKey2";
        String designatedKey3 = "newKey3";
        String value1 = "value1";
        String value2_designated = "designated-value2";
        String value2_deprecated = "deprecated-value2";
        Configuration cfg = new Configuration();
        cfg.setString(deprecatedKey1, value1);
        cfg.setString(deprecatedKey2, value2_deprecated);
        cfg.setString(designatedKey2, value2_designated);
        BootstrapTools.substituteDeprecatedConfigKey((Configuration)cfg, (String)deprecatedKey1, (String)designatedKey1);
        BootstrapTools.substituteDeprecatedConfigKey((Configuration)cfg, (String)deprecatedKey2, (String)designatedKey2);
        BootstrapTools.substituteDeprecatedConfigKey((Configuration)cfg, (String)deprecatedKey3, (String)designatedKey3);
        Assert.assertEquals((Object)value1, (Object)cfg.getString(designatedKey1, null));
        Assert.assertEquals((Object)value2_designated, (Object)cfg.getString(designatedKey2, null));
        Assert.assertNull((Object)cfg.getString(designatedKey3, null));
        Assert.assertNull((Object)cfg.getString(deprecatedKey3, null));
    }

    @Test
    public void testSubstituteConfigKeyPrefix() {
        String deprecatedPrefix1 = "deprecated-prefix";
        String deprecatedPrefix2 = "-prefix-2";
        String deprecatedPrefix3 = "prefix-3";
        String designatedPrefix1 = "p1";
        String designatedPrefix2 = "ppp";
        String designatedPrefix3 = "zzz";
        String depr1 = deprecatedPrefix1 + "var";
        String depr2 = deprecatedPrefix2 + "env";
        String depr3 = deprecatedPrefix2 + "x";
        String desig1 = designatedPrefix1 + "var";
        String desig2 = designatedPrefix2 + "env";
        String desig3 = designatedPrefix2 + "x";
        String val1 = "1";
        String val2 = "2";
        String val3_depr = "3-";
        String val3_desig = "3+";
        Configuration cfg = new Configuration();
        cfg.setString(depr1, val1);
        cfg.setString(depr2, val2);
        cfg.setString(depr3, val3_depr);
        cfg.setString(desig3, val3_desig);
        BootstrapTools.substituteDeprecatedConfigPrefix((Configuration)cfg, (String)deprecatedPrefix1, (String)designatedPrefix1);
        BootstrapTools.substituteDeprecatedConfigPrefix((Configuration)cfg, (String)deprecatedPrefix2, (String)designatedPrefix2);
        BootstrapTools.substituteDeprecatedConfigPrefix((Configuration)cfg, (String)deprecatedPrefix3, (String)designatedPrefix3);
        Assert.assertEquals((Object)val1, (Object)cfg.getString(desig1, null));
        Assert.assertEquals((Object)val2, (Object)cfg.getString(desig2, null));
        Assert.assertEquals((Object)val3_desig, (Object)cfg.getString(desig3, null));
        for (String key : cfg.keySet()) {
            Assert.assertFalse((boolean)key.startsWith(designatedPrefix3));
            Assert.assertFalse((boolean)key.startsWith(deprecatedPrefix3));
        }
    }
}

