/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.savepoint;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.checkpoint.TaskState;
import org.apache.flink.runtime.checkpoint.savepoint.FsSavepointStore;
import org.apache.flink.runtime.checkpoint.savepoint.Savepoint;
import org.apache.flink.runtime.checkpoint.savepoint.SavepointSerializer;
import org.apache.flink.runtime.checkpoint.savepoint.SavepointSerializers;
import org.apache.flink.runtime.checkpoint.savepoint.SavepointV0;
import org.apache.flink.runtime.checkpoint.savepoint.SavepointV01Test;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class FsSavepointStoreTest {
    @Rule
    public TemporaryFolder tmp = new TemporaryFolder();

    @Test
    public void testStoreLoadDispose() throws Exception {
        FsSavepointStore store = new FsSavepointStore(this.tmp.getRoot().getPath(), "fs-savepoint-store-test-");
        Assert.assertEquals((long)0L, (long)this.tmp.getRoot().listFiles().length);
        SavepointV0 stored = new SavepointV0(1929292L, SavepointV01Test.createTaskStates(4, 24));
        String path = store.storeSavepoint((Savepoint)stored);
        Assert.assertEquals((long)1L, (long)this.tmp.getRoot().listFiles().length);
        Savepoint loaded = store.loadSavepoint(path);
        Assert.assertEquals((Object)stored, (Object)loaded);
        store.disposeSavepoint(path, ClassLoader.getSystemClassLoader());
        Assert.assertEquals((long)0L, (long)this.tmp.getRoot().listFiles().length);
    }

    @Test
    public void testUnexpectedSavepoint() throws Exception {
        FsSavepointStore store = new FsSavepointStore(this.tmp.getRoot().getPath(), "fs-savepoint-store-test-");
        Path filePath = new Path(this.tmp.getRoot().getPath(), UUID.randomUUID().toString());
        FSDataOutputStream fdos = FileSystem.get((URI)filePath.toUri()).create(filePath, false);
        DataOutputStream dos = new DataOutputStream((OutputStream)fdos);
        for (int i = 0; i < 10; ++i) {
            dos.writeLong(ThreadLocalRandom.current().nextLong());
        }
        try {
            store.loadSavepoint(filePath.toString());
            Assert.fail((String)"Did not throw expected Exception");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((e.getMessage().contains("Flink 1.0") && e.getMessage().contains("Unexpected magic number") ? 1 : 0) != 0);
        }
    }

    @Test
    public void testMultipleSavepointVersions() throws Exception {
        Field field = SavepointSerializers.class.getDeclaredField("SERIALIZERS");
        field.setAccessible(true);
        Map serializers = (Map)field.get(null);
        Assert.assertTrue((serializers.size() >= 1 ? 1 : 0) != 0);
        FsSavepointStore store = new FsSavepointStore(this.tmp.getRoot().getPath(), "fs-savepoint-store-test-");
        Assert.assertEquals((long)0L, (long)this.tmp.getRoot().listFiles().length);
        int version = ThreadLocalRandom.current().nextInt();
        long checkpointId = ThreadLocalRandom.current().nextLong();
        serializers.put(version, NewSavepointSerializer.INSTANCE);
        TestSavepoint newSavepoint = new TestSavepoint(version, checkpointId);
        String pathNewSavepoint = store.storeSavepoint((Savepoint)newSavepoint);
        Assert.assertEquals((long)1L, (long)this.tmp.getRoot().listFiles().length);
        SavepointV0 savepoint = new SavepointV0(checkpointId, SavepointV01Test.createTaskStates(4, 32));
        String pathSavepoint = store.storeSavepoint((Savepoint)savepoint);
        Assert.assertEquals((long)2L, (long)this.tmp.getRoot().listFiles().length);
        Savepoint loaded = store.loadSavepoint(pathNewSavepoint);
        Assert.assertEquals((Object)newSavepoint, (Object)loaded);
        loaded = store.loadSavepoint(pathSavepoint);
        Assert.assertEquals((Object)savepoint, (Object)loaded);
    }

    @Test
    public void testCleanupOnStoreFailure() throws Exception {
        Field field = SavepointSerializers.class.getDeclaredField("SERIALIZERS");
        field.setAccessible(true);
        Map serializers = (Map)field.get(null);
        int version = 123123;
        SavepointSerializer serializer = (SavepointSerializer)Mockito.mock(SavepointSerializer.class);
        ((SavepointSerializer)Mockito.doThrow((Throwable)new RuntimeException("Test Exception")).when((Object)serializer)).serialize((Savepoint)Matchers.any(TestSavepoint.class), (DataOutputStream)Matchers.any(DataOutputStream.class));
        FsSavepointStore store = new FsSavepointStore(this.tmp.getRoot().getPath(), "fs-savepoint-store-test-");
        serializers.put(123123, serializer);
        TestSavepoint savepoint = new TestSavepoint(123123, 12123123L);
        Assert.assertEquals((long)0L, (long)this.tmp.getRoot().listFiles().length);
        try {
            store.storeSavepoint((Savepoint)savepoint);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Assert.assertEquals((String)"Savepoint file not cleaned up on failure", (long)0L, (long)this.tmp.getRoot().listFiles().length);
    }

    private static class TestSavepoint
    implements Savepoint {
        private final int version;
        private final long checkpointId;

        public TestSavepoint(int version, long checkpointId) {
            this.version = version;
            this.checkpointId = checkpointId;
        }

        public int getVersion() {
            return this.version;
        }

        public long getCheckpointId() {
            return this.checkpointId;
        }

        public Collection<TaskState> getTaskStates() {
            return Collections.EMPTY_LIST;
        }

        public void dispose(ClassLoader classLoader) {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestSavepoint that = (TestSavepoint)o;
            return this.version == that.version && this.checkpointId == that.checkpointId;
        }

        public int hashCode() {
            int result = this.version;
            result = 31 * result + (int)(this.checkpointId ^ this.checkpointId >>> 32);
            return result;
        }
    }

    private static class NewSavepointSerializer
    implements SavepointSerializer<TestSavepoint> {
        private static final NewSavepointSerializer INSTANCE = new NewSavepointSerializer();

        private NewSavepointSerializer() {
        }

        public void serialize(TestSavepoint savepoint, DataOutputStream dos) throws IOException {
            dos.writeInt(savepoint.version);
            dos.writeLong(savepoint.checkpointId);
        }

        public TestSavepoint deserialize(DataInputStream dis) throws IOException {
            int version = dis.readInt();
            long checkpointId = dis.readLong();
            return new TestSavepoint(version, checkpointId);
        }
    }
}

