/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.flink.util.TraversableOnceException;

public class UnionIterator<T>
implements Iterator<T>,
Iterable<T> {
    private Iterator<T> currentIterator;
    private ArrayList<List<T>> furtherLists = new ArrayList();
    private int nextList;
    private boolean iteratorAvailable = true;

    public void clear() {
        this.currentIterator = null;
        this.furtherLists.clear();
        this.nextList = 0;
        this.iteratorAvailable = true;
    }

    public void addList(List<T> list) {
        if (this.currentIterator == null) {
            this.currentIterator = list.iterator();
        } else {
            this.furtherLists.add(list);
        }
    }

    @Override
    public Iterator<T> iterator() {
        if (this.iteratorAvailable) {
            this.iteratorAvailable = false;
            return this;
        }
        throw new TraversableOnceException();
    }

    @Override
    public boolean hasNext() {
        while (this.currentIterator != null) {
            if (this.currentIterator.hasNext()) {
                return true;
            }
            if (this.nextList < this.furtherLists.size()) {
                this.currentIterator = this.furtherLists.get(this.nextList).iterator();
                ++this.nextList;
                continue;
            }
            this.currentIterator = null;
        }
        return false;
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            return this.currentIterator.next();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

