/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.InstantiationUtil;

public class SerializedThrowable
extends Exception
implements Serializable {
    private static final long serialVersionUID = 7284183123441947635L;
    private final byte[] serializedException;
    private final String originalErrorClassName;
    private final String fullStingifiedStackTrace;
    private final Exception placeholder;
    private transient WeakReference<Throwable> cachedException;

    public SerializedThrowable(Throwable exception) {
        super(SerializedThrowable.getMessageOrError(exception));
        if (!(exception instanceof SerializedThrowable)) {
            byte[] serialized;
            this.cachedException = new WeakReference<Throwable>(exception);
            this.originalErrorClassName = exception.getClass().getName();
            this.fullStingifiedStackTrace = ExceptionUtils.stringifyException((Throwable)exception);
            this.placeholder = new Exception("Serialized representation of " + this.originalErrorClassName + ": " + this.getMessage());
            this.placeholder.setStackTrace(exception.getStackTrace());
            this.initCause(this.placeholder);
            try {
                serialized = InstantiationUtil.serializeObject((Object)exception);
            }
            catch (Throwable t) {
                try {
                    serialized = InstantiationUtil.serializeObject((Object)this.placeholder);
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            this.serializedException = serialized;
        } else {
            SerializedThrowable other = (SerializedThrowable)exception;
            this.serializedException = other.serializedException;
            this.originalErrorClassName = other.originalErrorClassName;
            this.fullStingifiedStackTrace = other.fullStingifiedStackTrace;
            this.placeholder = other.placeholder;
            this.cachedException = other.cachedException;
        }
    }

    public Throwable deserializeError(ClassLoader userCodeClassloader) {
        Throwable cached;
        Throwable throwable = cached = this.cachedException == null ? null : (Throwable)this.cachedException.get();
        if (cached == null) {
            try {
                cached = (Throwable)InstantiationUtil.deserializeObject((byte[])this.serializedException, (ClassLoader)userCodeClassloader);
                this.cachedException = new WeakReference<Throwable>(cached);
            }
            catch (Exception e) {
                return this.placeholder;
            }
        }
        return cached;
    }

    public String getStrigifiedStackTrace() {
        return this.fullStingifiedStackTrace;
    }

    @Override
    public Throwable getCause() {
        return this.placeholder;
    }

    @Override
    public void printStackTrace(PrintStream s) {
        s.print(this.fullStingifiedStackTrace);
        s.flush();
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        s.print(this.fullStingifiedStackTrace);
        s.flush();
    }

    @Override
    public String toString() {
        String message = this.getLocalizedMessage();
        return message != null ? this.originalErrorClassName + ": " + message : this.originalErrorClassName;
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        return this.placeholder.getStackTrace();
    }

    public static Throwable get(Throwable serThrowable, ClassLoader loader) {
        if (serThrowable instanceof SerializedThrowable) {
            return ((SerializedThrowable)serThrowable).deserializeError(loader);
        }
        return serThrowable;
    }

    private static String getMessageOrError(Throwable error) {
        try {
            return error.getMessage();
        }
        catch (Throwable t) {
            return "(failed to get message)";
        }
    }
}

