/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class LRUCacheMap<K, V> {
    private final LinkedHashMap<K, V> lruCache = new LinkedHashMap(16, 0.75f, true);

    public static <K, V> LRUCacheMap<K, V> create() {
        return new LRUCacheMap<K, V>();
    }

    public void put(K key, V value) {
        this.lruCache.put(key, value);
    }

    public V get(K key) {
        return this.lruCache.get(key);
    }

    public V getLRU() {
        Iterator<Map.Entry<K, V>> i$ = this.lruCache.entrySet().iterator();
        if (i$.hasNext()) {
            Map.Entry<K, V> entry = i$.next();
            return this.lruCache.get(entry.getKey());
        }
        return null;
    }

    public V remove(K key) {
        return this.lruCache.remove(key);
    }

    public V removeLRU() {
        Iterator<Map.Entry<K, V>> i$ = this.lruCache.entrySet().iterator();
        if (i$.hasNext()) {
            Map.Entry<K, V> entry = i$.next();
            return this.lruCache.remove(entry.getKey());
        }
        return null;
    }

    public boolean containsKey(K key) {
        return this.lruCache.containsKey(key);
    }

    public boolean isEmpty() {
        return this.lruCache.isEmpty();
    }

    public int size() {
        return this.lruCache.size();
    }
}

