/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskmanager;

import akka.actor.ActorNotFound;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.Props$;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jvm.BufferPoolMetricSet;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.typesafe.config.Config;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logger$;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import java.net.BindException;
import java.net.InetAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.memory.HeapMemorySegment;
import org.apache.flink.core.memory.HybridMemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.core.memory.MemoryType;
import org.apache.flink.runtime.akka.AkkaUtils$;
import org.apache.flink.runtime.instance.InstanceConnectionInfo;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.io.network.NetworkEnvironment;
import org.apache.flink.runtime.io.network.netty.NettyConfig;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.process.ProcessReaper;
import org.apache.flink.runtime.security.SecurityUtils;
import org.apache.flink.runtime.taskmanager.MemoryLogger;
import org.apache.flink.runtime.taskmanager.NetworkEnvironmentConfiguration;
import org.apache.flink.runtime.taskmanager.NetworkEnvironmentConfiguration$;
import org.apache.flink.runtime.taskmanager.TaskManager;
import org.apache.flink.runtime.taskmanager.TaskManager$;
import org.apache.flink.runtime.taskmanager.TaskManagerCliOptions;
import org.apache.flink.runtime.taskmanager.TaskManagerConfiguration;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.runtime.util.LeaderRetrievalUtils;
import org.apache.flink.runtime.util.MathUtils;
import org.apache.flink.runtime.util.SignalHandler;
import org.apache.flink.util.NetUtils;
import org.jboss.netty.channel.ChannelException;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.concurrent.forkjoin.ForkJoinPool;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scopt.OptionParser;
import scopt.Read$;

public final class TaskManager$ {
    public static final TaskManager$ MODULE$;
    private final Logger LOG;
    private final int STARTUP_FAILURE_RETURN_CODE;
    private final int RUNTIME_FAILURE_RETURN_CODE;
    private final String TASK_MANAGER_NAME;
    private final long MAX_STARTUP_CONNECT_TIME;
    private final long STARTUP_CONNECT_LOG_SUPPRESS;
    private final FiniteDuration INITIAL_REGISTRATION_TIMEOUT;
    private final FiniteDuration MAX_REGISTRATION_TIMEOUT;
    private final FiniteDuration DELAY_AFTER_REFUSED_REGISTRATION;
    private final FiniteDuration HEARTBEAT_INTERVAL;

    static {
        new TaskManager$();
    }

    public Logger LOG() {
        return this.LOG;
    }

    public int STARTUP_FAILURE_RETURN_CODE() {
        return this.STARTUP_FAILURE_RETURN_CODE;
    }

    public int RUNTIME_FAILURE_RETURN_CODE() {
        return this.RUNTIME_FAILURE_RETURN_CODE;
    }

    public String TASK_MANAGER_NAME() {
        return this.TASK_MANAGER_NAME;
    }

    public long MAX_STARTUP_CONNECT_TIME() {
        return this.MAX_STARTUP_CONNECT_TIME;
    }

    public long STARTUP_CONNECT_LOG_SUPPRESS() {
        return this.STARTUP_CONNECT_LOG_SUPPRESS;
    }

    public FiniteDuration INITIAL_REGISTRATION_TIMEOUT() {
        return this.INITIAL_REGISTRATION_TIMEOUT;
    }

    public FiniteDuration MAX_REGISTRATION_TIMEOUT() {
        return this.MAX_REGISTRATION_TIMEOUT;
    }

    public FiniteDuration DELAY_AFTER_REFUSED_REGISTRATION() {
        return this.DELAY_AFTER_REFUSED_REGISTRATION;
    }

    public FiniteDuration HEARTBEAT_INTERVAL() {
        return this.HEARTBEAT_INTERVAL;
    }

    public void main(String[] args) {
        Configuration configuration;
        EnvironmentInformation.logEnvironmentInfo(this.LOG().logger(), "TaskManager", args);
        SignalHandler.register(this.LOG().logger());
        long maxOpenFileHandles = EnvironmentInformation.getOpenFileHandlesLimit();
        if (maxOpenFileHandles != -1L) {
            this.LOG().info((Function0)new Serializable(maxOpenFileHandles){
                public static final long serialVersionUID = 0L;
                private final long maxOpenFileHandles$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Maximum number of open file descriptors is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.maxOpenFileHandles$1)}));
                }
                {
                    this.maxOpenFileHandles$1 = maxOpenFileHandles$1;
                }
            });
        } else {
            this.LOG().info((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Cannot determine the maximum number of open file descriptors";
                }
            });
        }
        try {
            configuration = this.parseArgsAndLoadConfig(args);
        }
        catch (Throwable throwable) {
            this.LOG().error((Function0)new Serializable(throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$9;

                public final String apply() {
                    return this.t$9.getMessage();
                }
                {
                    this.t$9 = t$9;
                }
            }, (Function0)new Serializable(throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$9;

                public final Throwable apply() {
                    return this.t$9;
                }
                {
                    this.t$9 = t$9;
                }
            });
            System.exit(this.STARTUP_FAILURE_RETURN_CODE());
            configuration = null;
        }
        Configuration configuration2 = configuration;
        try {
            if (SecurityUtils.isSecurityEnabled()) {
                this.LOG().info((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Security is enabled. Starting secure TaskManager.";
                    }
                });
                SecurityUtils.runSecured(new SecurityUtils.FlinkSecuredRunner<BoxedUnit>(configuration2){
                    private final Configuration configuration$1;

                    public void run() {
                        TaskManager$.MODULE$.selectNetworkInterfaceAndRunTaskManager(this.configuration$1, TaskManager.class);
                    }
                    {
                        this.configuration$1 = configuration$1;
                    }
                });
            } else {
                this.LOG().info((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Security is not enabled. Starting non-authenticated TaskManager.";
                    }
                });
                this.selectNetworkInterfaceAndRunTaskManager(configuration2, TaskManager.class);
            }
        }
        catch (Throwable throwable) {
            this.LOG().error((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Failed to run TaskManager.";
                }
            }, (Function0)new Serializable(throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$10;

                public final Throwable apply() {
                    return this.t$10;
                }
                {
                    this.t$10 = t$10;
                }
            });
            System.exit(this.STARTUP_FAILURE_RETURN_CODE());
        }
    }

    public Configuration parseArgsAndLoadConfig(String[] args) throws Exception {
        Configuration conf;
        OptionParser<TaskManagerCliOptions> parser = new OptionParser<TaskManagerCliOptions>(){
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Flink TaskManager"}));
                this.opt("configDir", Read$.MODULE$.stringRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final TaskManagerCliOptions apply(String param, TaskManagerCliOptions conf) {
                        conf.setConfigDir(param);
                        return conf;
                    }
                }).text("Specify configuration directory.");
            }
        };
        TaskManagerCliOptions cliConfig = (TaskManagerCliOptions)parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)new TaskManagerCliOptions()).getOrElse((Function0)new Serializable(args, (OptionParser)parser){
            public static final long serialVersionUID = 0L;
            private final String[] args$1;
            private final OptionParser parser$1;

            public final Nothing$ apply() {
                throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid command line arguments: ", ". Usage: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])this.args$1).mkString(" "), this.parser$1.usage()})));
            }
            {
                this.args$1 = args$1;
                this.parser$1 = parser$1;
            }
        });
        try {
            this.LOG().info((Function0)new Serializable(cliConfig){
                public static final long serialVersionUID = 0L;
                private final TaskManagerCliOptions cliConfig$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Loading configuration from ").append((Object)this.cliConfig$1.getConfigDir()).toString();
                }
                {
                    this.cliConfig$1 = cliConfig$1;
                }
            });
            GlobalConfiguration.loadConfiguration((String)cliConfig.getConfigDir());
            conf = GlobalConfiguration.getConfiguration();
        }
        catch (Exception exception) {
            throw new Exception("Could not load configuration", exception);
        }
        try {
            FileSystem.setDefaultScheme((Configuration)conf);
            return conf;
        }
        catch (IOException iOException) {
            throw new Exception("Error while setting the default filesystem scheme from configuration.", iOException);
        }
    }

    public void selectNetworkInterfaceAndRunTaskManager(Configuration configuration, Class<? extends TaskManager> taskManagerClass) throws Exception {
        Tuple2<String, Object> tuple2 = this.selectNetworkInterfaceAndPort(configuration);
        if (tuple2 != null) {
            Tuple2 tuple22;
            String taskManagerHostname = (String)tuple2._1();
            int actorSystemPort = tuple2._2$mcI$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)taskManagerHostname, (Object)BoxesRunTime.boxToInteger((int)actorSystemPort));
            String taskManagerHostname2 = (String)tuple23._1();
            int actorSystemPort2 = tuple23._2$mcI$sp();
            this.runTaskManager(taskManagerHostname2, actorSystemPort2, configuration, taskManagerClass);
            return;
        }
        throw new MatchError(tuple2);
    }

    public Tuple2<String, Object> selectNetworkInterfaceAndPort(Configuration configuration) throws IOException, IllegalConfigurationException {
        ObjectRef taskManagerHostname = new ObjectRef((Object)configuration.getString("taskmanager.hostname", null));
        if ((String)taskManagerHostname.elem == null) {
            LeaderRetrievalService leaderRetrievalService = LeaderRetrievalUtils.createLeaderRetrievalService(configuration);
            FiniteDuration lookupTimeout = AkkaUtils$.MODULE$.getLookupTimeout(configuration);
            InetAddress taskManagerAddress = LeaderRetrievalUtils.findConnectingAddress(leaderRetrievalService, lookupTimeout);
            taskManagerHostname.elem = taskManagerAddress.getHostName();
            this.LOG().info((Function0)new Serializable(taskManagerHostname, taskManagerAddress){
                public static final long serialVersionUID = 0L;
                private final ObjectRef taskManagerHostname$2;
                private final InetAddress taskManagerAddress$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaskManager will use hostname/address '", "' "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(String)this.taskManagerHostname$2.elem}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ") for communication."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.taskManagerAddress$1.getHostAddress()}))).toString();
                }
                {
                    this.taskManagerHostname$2 = taskManagerHostname$2;
                    this.taskManagerAddress$1 = taskManagerAddress$1;
                }
            });
        } else {
            this.LOG().info((Function0)new Serializable(taskManagerHostname){
                public static final long serialVersionUID = 0L;
                private final ObjectRef taskManagerHostname$2;

                public final String apply() {
                    return new StringBuilder().append((Object)"Using configured hostname/address for TaskManager: ").append((Object)((String)this.taskManagerHostname$2.elem)).toString();
                }
                {
                    this.taskManagerHostname$2 = taskManagerHostname$2;
                }
            });
        }
        int actorSystemPort = configuration.getInteger("taskmanager.rpc.port", 0);
        if (actorSystemPort < 0 || actorSystemPort > 65535) {
            throw new IllegalConfigurationException(new StringBuilder().append((Object)"Invalid value for 'taskmanager.rpc.port' (port for the TaskManager actor system) : ").append((Object)BoxesRunTime.boxToInteger((int)actorSystemPort)).append((Object)" - Leave config parameter empty or use 0 to let the system choose a port automatically.").toString());
        }
        return new Tuple2((Object)((String)taskManagerHostname.elem), (Object)BoxesRunTime.boxToInteger((int)actorSystemPort));
    }

    public void runTaskManager(String taskManagerHostname, int actorSystemPort, Configuration configuration) throws Exception {
        this.runTaskManager(taskManagerHostname, actorSystemPort, configuration, TaskManager.class);
    }

    public void runTaskManager(String taskManagerHostname, int actorSystemPort, Configuration configuration, Class<? extends TaskManager> taskManagerClass) throws Exception {
        ActorSystem taskManagerSystem;
        this.LOG().info((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Starting TaskManager"})).s((Seq)Nil$.MODULE$);
            }
        });
        this.LOG().info((Function0)new Serializable(taskManagerHostname, actorSystemPort){
            public static final long serialVersionUID = 0L;
            private final String taskManagerHostname$1;
            private final int actorSystemPort$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Starting TaskManager actor system at ").append((Object)NetUtils.hostAndPortToUrlString((String)this.taskManagerHostname$1, (int)this.actorSystemPort$1)).toString();
            }
            {
                this.taskManagerHostname$1 = taskManagerHostname$1;
                this.actorSystemPort$1 = actorSystemPort$1;
            }
        });
        try {
            Config akkaConfig = AkkaUtils$.MODULE$.getAkkaConfig(configuration, (Option<Tuple2<String, Object>>)new Some((Object)new Tuple2((Object)taskManagerHostname, (Object)BoxesRunTime.boxToInteger((int)actorSystemPort))));
            if (this.LOG().isDebugEnabled()) {
                this.LOG().debug((Function0)new Serializable(akkaConfig){
                    public static final long serialVersionUID = 0L;
                    private final Config akkaConfig$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Using akka configuration\n ").append((Object)this.akkaConfig$1).toString();
                    }
                    {
                        this.akkaConfig$1 = akkaConfig$1;
                    }
                });
            }
            taskManagerSystem = AkkaUtils$.MODULE$.createActorSystem(akkaConfig);
        }
        catch (Throwable throwable) {
            Throwable cause;
            if (throwable instanceof ChannelException && (cause = throwable.getCause()) != null && throwable.getCause() instanceof BindException) {
                String address = NetUtils.hostAndPortToUrlString((String)taskManagerHostname, (int)actorSystemPort);
                throw new IOException(new StringBuilder().append((Object)"Unable to bind TaskManager actor system to address ").append((Object)address).append((Object)" - ").append((Object)cause.getMessage()).toString(), throwable);
            }
            throw new Exception("Could not create TaskManager actor system", throwable);
        }
        try {
            this.LOG().info((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Starting TaskManager actor";
                }
            });
            ActorRef taskManager = this.startTaskManagerComponentsAndActor(configuration, taskManagerSystem, taskManagerHostname, (Option<String>)new Some((Object)this.TASK_MANAGER_NAME()), (Option<LeaderRetrievalService>)None$.MODULE$, false, taskManagerClass);
            this.LOG().debug((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Starting TaskManager process reaper";
                }
            });
            taskManagerSystem.actorOf(Props$.MODULE$.apply(ProcessReaper.class, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{taskManager, this.LOG().logger(), BoxesRunTime.boxToInteger((int)this.RUNTIME_FAILURE_RETURN_CODE())})), "TaskManager_Process_Reaper");
            if (this.LOG().isInfoEnabled() && configuration.getBoolean("taskmanager.debug.memory.startLogThread", false)) {
                this.LOG().info((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Starting periodic memory usage logger";
                    }
                });
                long interval = configuration.getLong("taskmanager.debug.memory.logIntervalMs", 5000L);
                MemoryLogger logger = new MemoryLogger(this.LOG().logger(), interval, taskManagerSystem);
                logger.start();
            }
            taskManagerSystem.awaitTermination();
            return;
        }
        catch (Throwable throwable) {
            this.LOG().error((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Error while starting up taskManager";
                }
            }, (Function0)new Serializable(throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$11;

                public final Throwable apply() {
                    return this.t$11;
                }
                {
                    this.t$11 = t$11;
                }
            });
            try {
                taskManagerSystem.shutdown();
            }
            catch (Throwable throwable2) {
                this.LOG().warn((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Could not cleanly shut down actor system";
                    }
                }, (Function0)new Serializable(throwable2){
                    public static final long serialVersionUID = 0L;
                    private final Throwable tt$1;

                    public final Throwable apply() {
                        return this.tt$1;
                    }
                    {
                        this.tt$1 = tt$1;
                    }
                });
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public ActorRef startTaskManagerComponentsAndActor(Configuration configuration, ActorSystem actorSystem, String taskManagerHostname, Option<String> taskManagerActorName, Option<LeaderRetrievalService> leaderRetrievalServiceOption, boolean localTaskManagerCommunication, Class<? extends TaskManager> taskManagerClass) throws IllegalConfigurationException, IOException, Exception {
        Tuple4<TaskManagerConfiguration, NetworkEnvironmentConfiguration, InstanceConnectionInfo, MemoryType> tuple4;
        block13: {
            block17: {
                Option<LeaderRetrievalService> option;
                block20: {
                    Option<String> option2;
                    block23: {
                        ActorRef actorRef;
                        block22: {
                            Props tmProps;
                            block21: {
                                LeaderRetrievalService leaderRetrievalService;
                                IOManagerAsync ioManager;
                                MemoryManager memoryManager;
                                NetworkEnvironment network;
                                InstanceConnectionInfo connectionInfo;
                                TaskManagerConfiguration taskManagerConfig;
                                block19: {
                                    block18: {
                                        LeaderRetrievalService lrs;
                                        long l;
                                        boolean preAllocateMemory;
                                        MemoryType memType;
                                        NetworkEnvironmentConfiguration netConfig;
                                        block15: {
                                            float fraction;
                                            block16: {
                                                block14: {
                                                    Tuple4 tuple42;
                                                    tuple4 = this.parseTaskManagerConfiguration(configuration, taskManagerHostname, localTaskManagerCommunication);
                                                    if (tuple4 == null) break block13;
                                                    TaskManagerConfiguration taskManagerConfig2 = (TaskManagerConfiguration)tuple4._1();
                                                    NetworkEnvironmentConfiguration netConfig2 = (NetworkEnvironmentConfiguration)tuple4._2();
                                                    InstanceConnectionInfo connectionInfo2 = (InstanceConnectionInfo)tuple4._3();
                                                    MemoryType memType2 = (MemoryType)tuple4._4();
                                                    if (taskManagerConfig2 == null) break block13;
                                                    TaskManagerConfiguration taskManagerConfiguration = taskManagerConfig2;
                                                    if (netConfig2 == null) break block13;
                                                    NetworkEnvironmentConfiguration networkEnvironmentConfiguration = netConfig2;
                                                    if (connectionInfo2 == null) break block13;
                                                    InstanceConnectionInfo instanceConnectionInfo = connectionInfo2;
                                                    if (memType2 == null) break block13;
                                                    MemoryType memoryType = memType2;
                                                    Tuple4 tuple43 = tuple42 = new Tuple4((Object)taskManagerConfiguration, (Object)networkEnvironmentConfiguration, (Object)instanceConnectionInfo, (Object)memoryType);
                                                    taskManagerConfig = (TaskManagerConfiguration)tuple43._1();
                                                    netConfig = (NetworkEnvironmentConfiguration)tuple43._2();
                                                    connectionInfo = (InstanceConnectionInfo)tuple43._3();
                                                    memType = (MemoryType)tuple43._4();
                                                    this.checkTempDirs(taskManagerConfig.tmpDirPaths());
                                                    ExecutionContextExecutor executionContext = ExecutionContext$.MODULE$.fromExecutor((Executor)new ForkJoinPool());
                                                    network = new NetworkEnvironment((ExecutionContext)executionContext, taskManagerConfig.timeout(), netConfig);
                                                    long configuredMemory = configuration.getLong("taskmanager.memory.size", -1L);
                                                    this.checkConfigParameter(configuredMemory == -1L || configuredMemory > 0L, BoxesRunTime.boxToLong((long)configuredMemory), "taskmanager.memory.size", "MemoryManager needs at least one MB of memory. If you leave this config parameter empty, the system automatically pick a fraction of the available memory.");
                                                    preAllocateMemory = configuration.getBoolean("taskmanager.memory.preallocate", false);
                                                    if (configuredMemory <= 0L) break block14;
                                                    if (preAllocateMemory) {
                                                        this.LOG().info((Function0)new Serializable(configuredMemory){
                                                            public static final long serialVersionUID = 0L;
                                                            private final long configuredMemory$1;

                                                            public final String apply() {
                                                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Using ", " MB for managed memory."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.configuredMemory$1)}));
                                                            }
                                                            {
                                                                this.configuredMemory$1 = configuredMemory$1;
                                                            }
                                                        });
                                                    } else {
                                                        this.LOG().info((Function0)new Serializable(configuredMemory){
                                                            public static final long serialVersionUID = 0L;
                                                            private final long configuredMemory$1;

                                                            public final String apply() {
                                                                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Limiting managed memory to ", " MB, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.configuredMemory$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"memory will be allocated lazily."})).s((Seq)Nil$.MODULE$)).toString();
                                                            }
                                                            {
                                                                this.configuredMemory$1 = configuredMemory$1;
                                                            }
                                                        });
                                                    }
                                                    l = configuredMemory << 20;
                                                    break block15;
                                                }
                                                fraction = configuration.getFloat("taskmanager.memory.fraction", 0.7f);
                                                this.checkConfigParameter(fraction > 0.0f && fraction < 1.0f, BoxesRunTime.boxToFloat((float)fraction), "taskmanager.memory.fraction", "MemoryManager fraction of the free memory must be between 0.0 and 1.0");
                                                MemoryType memoryType = memType;
                                                MemoryType memoryType2 = MemoryType.HEAP;
                                                if (memoryType != null ? !memoryType.equals(memoryType2) : memoryType2 != null) break block16;
                                                long relativeMemSize = (long)((double)EnvironmentInformation.getSizeOfFreeHeapMemoryWithDefrag() * (double)fraction);
                                                if (preAllocateMemory) {
                                                    this.LOG().info((Function0)new Serializable(fraction, relativeMemSize){
                                                        public static final long serialVersionUID = 0L;
                                                        private final float fraction$1;
                                                        private final long relativeMemSize$1;

                                                        public final String apply() {
                                                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Using ", " of the currently free heap space for managed "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)this.fraction$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"heap memory (", " MB)."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(this.relativeMemSize$1 >> 20))}))).toString();
                                                        }
                                                        {
                                                            this.fraction$1 = fraction$1;
                                                            this.relativeMemSize$1 = relativeMemSize$1;
                                                        }
                                                    });
                                                } else {
                                                    this.LOG().info((Function0)new Serializable(fraction, relativeMemSize){
                                                        public static final long serialVersionUID = 0L;
                                                        private final float fraction$1;
                                                        private final long relativeMemSize$1;

                                                        public final String apply() {
                                                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Limiting managed memory to ", " of the currently free heap space "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)this.fraction$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", " MB), memory will be allocated lazily."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(this.relativeMemSize$1 >> 20))}))).toString();
                                                        }
                                                        {
                                                            this.fraction$1 = fraction$1;
                                                            this.relativeMemSize$1 = relativeMemSize$1;
                                                        }
                                                    });
                                                }
                                                l = relativeMemSize;
                                                break block15;
                                            }
                                            MemoryType memoryType = memType;
                                            MemoryType memoryType3 = MemoryType.OFF_HEAP;
                                            if (memoryType != null ? !memoryType.equals(memoryType3) : memoryType3 != null) break block17;
                                            long maxMemory = EnvironmentInformation.getMaxJvmHeapMemory();
                                            long directMemorySize = (long)((double)maxMemory / (1.0 - (double)fraction) * (double)fraction);
                                            if (preAllocateMemory) {
                                                this.LOG().info((Function0)new Serializable(fraction, directMemorySize){
                                                    public static final long serialVersionUID = 0L;
                                                    private final float fraction$1;
                                                    private final long directMemorySize$1;

                                                    public final String apply() {
                                                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Using ", " of the maximum memory size for "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)this.fraction$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"managed off-heap memory (", " MB)."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(this.directMemorySize$1 >> 20))}))).toString();
                                                    }
                                                    {
                                                        this.fraction$1 = fraction$1;
                                                        this.directMemorySize$1 = directMemorySize$1;
                                                    }
                                                });
                                            } else {
                                                this.LOG().info((Function0)new Serializable(fraction, directMemorySize){
                                                    public static final long serialVersionUID = 0L;
                                                    private final float fraction$1;
                                                    private final long directMemorySize$1;

                                                    public final String apply() {
                                                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Limiting managed memory to ", " of the maximum memory size "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)this.fraction$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", " MB), memory will be allocated lazily."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(this.directMemorySize$1 >> 20))}))).toString();
                                                    }
                                                    {
                                                        this.fraction$1 = fraction$1;
                                                        this.directMemorySize$1 = directMemorySize$1;
                                                    }
                                                });
                                            }
                                            l = directMemorySize;
                                        }
                                        long memorySize = l;
                                        try {
                                            memoryManager = new MemoryManager(memorySize, taskManagerConfig.numberOfSlots(), netConfig.networkBufferSize(), memType, preAllocateMemory);
                                            ioManager = new IOManagerAsync(taskManagerConfig.tmpDirPaths());
                                            option = leaderRetrievalServiceOption;
                                        }
                                        catch (OutOfMemoryError outOfMemoryError) {
                                            void var37_33;
                                            void var22_22;
                                            void var54_49 = var22_22;
                                            MemoryType memoryType = MemoryType.HEAP;
                                            void var55_50 = var54_49;
                                            if (!(memoryType != null ? !memoryType.equals(var55_50) : var55_50 != null)) {
                                                throw new Exception(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"OutOfMemory error (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{outOfMemoryError.getMessage()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" while allocating the TaskManager heap memory (", " bytes)."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)var37_33)}))).toString(), outOfMemoryError);
                                            }
                                            MemoryType memoryType4 = MemoryType.OFF_HEAP;
                                            void var56_51 = var54_49;
                                            if (!(memoryType4 != null ? !memoryType4.equals(var56_51) : var56_51 != null)) {
                                                throw new Exception(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"OutOfMemory error (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{outOfMemoryError.getMessage()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" while allocating the TaskManager off-heap memory (", " bytes). "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)var37_33)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Try increasing the maximum direct memory (-XX:MaxDirectMemorySize)"})).s((Seq)Nil$.MODULE$)).toString(), outOfMemoryError);
                                            }
                                            throw outOfMemoryError;
                                        }
                                        if (!(option instanceof Some)) break block18;
                                        Some some = (Some)option;
                                        leaderRetrievalService = lrs = (LeaderRetrievalService)some.x();
                                        break block19;
                                    }
                                    None$ none$ = None$.MODULE$;
                                    Option<LeaderRetrievalService> option3 = option;
                                    if (none$ != null ? !none$.equals(option3) : option3 != null) break block20;
                                    leaderRetrievalService = LeaderRetrievalUtils.createLeaderRetrievalService(configuration);
                                }
                                LeaderRetrievalService leaderRetrievalService2 = leaderRetrievalService;
                                tmProps = Props$.MODULE$.apply(taskManagerClass, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{taskManagerConfig, connectionInfo, memoryManager, ioManager, network, BoxesRunTime.boxToInteger((int)taskManagerConfig.numberOfSlots()), leaderRetrievalService2}));
                                option2 = taskManagerActorName;
                                if (!(option2 instanceof Some)) break block21;
                                Some some = (Some)option2;
                                String actorName = (String)some.x();
                                actorRef = actorSystem.actorOf(tmProps, actorName);
                                break block22;
                            }
                            None$ none$ = None$.MODULE$;
                            Option<String> option4 = option2;
                            if (none$ != null ? !none$.equals(option4) : option4 != null) break block23;
                            actorRef = actorSystem.actorOf(tmProps);
                        }
                        return actorRef;
                    }
                    throw new MatchError(option2);
                }
                throw new MatchError(option);
            }
            throw new RuntimeException("No supported memory type detected.");
        }
        throw new MatchError(tuple4);
    }

    public ActorRef getTaskManagerRemoteReference(String taskManagerUrl, ActorSystem system, FiniteDuration timeout) throws IOException {
        try {
            Future<ActorRef> future = AkkaUtils$.MODULE$.getActorRefFuture(taskManagerUrl, system, timeout);
            return (ActorRef)Await$.MODULE$.result(future, (Duration)timeout);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof ActorNotFound ? true : throwable2 instanceof TimeoutException;
            if (bl) {
                throw new IOException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaskManager at ", " not reachable. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{taskManagerUrl}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Please make sure that the TaskManager is running and its port is reachable."})).s((Seq)Nil$.MODULE$)).toString(), throwable2);
            }
            if (throwable2 instanceof IOException) {
                IOException iOException = (IOException)throwable2;
                throw new IOException(new StringBuilder().append((Object)"Could not connect to TaskManager at ").append((Object)taskManagerUrl).toString(), iOException);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Tuple4<TaskManagerConfiguration, NetworkEnvironmentConfiguration, InstanceConnectionInfo, MemoryType> parseTaskManagerConfiguration(Configuration configuration, String taskManagerHostname, boolean localTaskManagerCommunication) throws IllegalArgumentException {
        None$ finiteRegistrationDuration;
        FiniteDuration timeout;
        String syncOrAsync;
        MemoryType memType;
        int n;
        int n2;
        int n3 = configuration.getInteger("taskmanager.data.port", 0);
        switch (n3) {
            default: {
                n2 = n3;
                break;
            }
            case 0: {
                n2 = NetUtils.getAvailablePort();
            }
        }
        int dataport = n2;
        this.checkConfigParameter(dataport > 0, BoxesRunTime.boxToInteger((int)dataport), "taskmanager.data.port", "Leave config parameter empty or use 0 to let the system choose a port automatically.");
        InetAddress taskManagerAddress = InetAddress.getByName(taskManagerHostname);
        InstanceConnectionInfo connectionInfo = new InstanceConnectionInfo(taskManagerAddress, dataport);
        int n4 = configuration.getInteger("taskmanager.numberOfTaskSlots", 1);
        switch (n4) {
            default: {
                n = n4;
                break;
            }
            case -1: {
                n = 1;
            }
        }
        int slots = n;
        this.checkConfigParameter(slots >= 1, BoxesRunTime.boxToInteger((int)slots), "taskmanager.numberOfTaskSlots", "Number of task slots must be at least one.");
        int numNetworkBuffers = configuration.getInteger("taskmanager.network.numberOfBuffers", 2048);
        this.checkConfigParameter(numNetworkBuffers > 0, BoxesRunTime.boxToInteger((int)numNetworkBuffers), "taskmanager.network.numberOfBuffers", this.checkConfigParameter$default$4());
        int pageSize = configuration.getInteger("taskmanager.memory.segment-size", 32768);
        this.checkConfigParameter(pageSize >= MemoryManager.MIN_PAGE_SIZE, BoxesRunTime.boxToInteger((int)pageSize), "taskmanager.memory.segment-size", new StringBuilder().append((Object)"Minimum memory segment size is ").append((Object)BoxesRunTime.boxToInteger((int)MemoryManager.MIN_PAGE_SIZE)).toString());
        this.checkConfigParameter(MathUtils.isPowerOf2(pageSize), BoxesRunTime.boxToInteger((int)pageSize), "taskmanager.memory.segment-size", "Memory segment size must be a power of 2.");
        MemoryType memoryType = memType = configuration.getBoolean("taskmanager.memory.off-heap", false) ? MemoryType.OFF_HEAP : MemoryType.HEAP;
        MemoryType memoryType2 = MemoryType.HEAP;
        MemoryType memoryType3 = memoryType;
        if (!(memoryType2 != null ? !memoryType2.equals(memoryType3) : memoryType3 != null)) {
            BoxedUnit boxedUnit;
            if (MemorySegmentFactory.isInitialized()) {
                MemorySegmentFactory.Factory factory = MemorySegmentFactory.getFactory();
                HeapMemorySegment.HeapMemorySegmentFactory heapMemorySegmentFactory = HeapMemorySegment.FACTORY;
                if (factory != null ? !factory.equals(heapMemorySegmentFactory) : heapMemorySegmentFactory != null) throw new Exception("Memory type is set to heap memory, but memory segment factory has been initialized for off-heap memory segments");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                MemorySegmentFactory.initializeFactory((MemorySegmentFactory.Factory)HeapMemorySegment.FACTORY);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            BoxedUnit boxedUnit;
            MemoryType memoryType4 = MemoryType.OFF_HEAP;
            MemoryType memoryType5 = memoryType;
            if (memoryType4 != null ? !memoryType4.equals(memoryType5) : memoryType5 != null) throw new MatchError((Object)memoryType);
            if (MemorySegmentFactory.isInitialized()) {
                MemorySegmentFactory.Factory factory = MemorySegmentFactory.getFactory();
                HybridMemorySegment.HybridMemorySegmentFactory hybridMemorySegmentFactory = HybridMemorySegment.FACTORY;
                if (factory != null ? !factory.equals(hybridMemorySegmentFactory) : hybridMemorySegmentFactory != null) throw new Exception("Memory type is set to off-heap memory, but memory segment factory has been initialized for heap memory segments");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                MemorySegmentFactory.initializeFactory((MemorySegmentFactory.Factory)HybridMemorySegment.FACTORY);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        }
        String[] tmpDirs = configuration.getString("taskmanager.tmp.dirs", ConfigConstants.DEFAULT_TASK_MANAGER_TMP_PATH).split(new StringBuilder().append((Object)",|").append((Object)File.pathSeparator).toString());
        None$ nettyConfig = localTaskManagerCommunication ? None$.MODULE$ : new Some((Object)new NettyConfig(connectionInfo.address(), connectionInfo.dataPort(), pageSize, slots, configuration));
        String string = syncOrAsync = configuration.getString("taskmanager.network.defaultIOMode", "sync");
        String string2 = "async";
        IOManager.IOMode ioMode = !(string != null ? !string.equals(string2) : string2 != null) ? IOManager.IOMode.ASYNC : IOManager.IOMode.SYNC;
        NetworkEnvironmentConfiguration networkConfig = new NetworkEnvironmentConfiguration(numNetworkBuffers, pageSize, memType, ioMode, (Option<NettyConfig>)nettyConfig, NetworkEnvironmentConfiguration$.MODULE$.apply$default$6());
        try {
            timeout = AkkaUtils$.MODULE$.getTimeout(configuration);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid format for '", "'. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"akka.ask.timeout"}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Use formats like '50 s' or '1 min' to specify the timeout."})).s((Seq)Nil$.MODULE$)).toString());
        }
        this.LOG().info((Function0)new Serializable(timeout){
            public static final long serialVersionUID = 0L;
            private final FiniteDuration timeout$2;

            public final String apply() {
                return new StringBuilder().append((Object)"Messages between TaskManager and JobManager have a max timeout of ").append((Object)this.timeout$2).toString();
            }
            {
                this.timeout$2 = timeout$2;
            }
        });
        long cleanupInterval = configuration.getLong("library-cache-manager.cleanup.interval", 3600L) * 1000L;
        try {
            Duration maxRegistrationDuration = Duration$.MODULE$.apply(configuration.getString("taskmanager.maxRegistrationDuration", "Inf"));
            finiteRegistrationDuration = maxRegistrationDuration.isFinite() ? new Some((Object)((FiniteDuration)maxRegistrationDuration)) : None$.MODULE$;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid format for parameter taskmanager.maxRegistrationDuration", numberFormatException);
        }
        TaskManagerConfiguration taskManagerConfig = new TaskManagerConfiguration(tmpDirs, cleanupInterval, timeout, (Option<FiniteDuration>)finiteRegistrationDuration, slots, configuration);
        return new Tuple4((Object)taskManagerConfig, (Object)networkConfig, (Object)connectionInfo, (Object)memType);
    }

    public Tuple2<String, Object> getAndCheckJobManagerAddress(Configuration configuration) {
        String hostname = configuration.getString("jobmanager.rpc.address", null);
        int port = configuration.getInteger("jobmanager.rpc.port", 6123);
        if (hostname == null) {
            throw new Exception("Config parameter 'jobmanager.rpc.address' is missing (hostname/address of JobManager to connect to).");
        }
        if (port <= 0 || port >= 65536) {
            throw new Exception(new StringBuilder().append((Object)"Invalid value for 'jobmanager.rpc.port' (port of the JobManager actor system) : ").append((Object)BoxesRunTime.boxToInteger((int)port)).append((Object)".  it must be great than 0 and less than 65536.").toString());
        }
        return new Tuple2((Object)hostname, (Object)BoxesRunTime.boxToInteger((int)port));
    }

    private void checkConfigParameter(boolean condition, Object parameter, String name, String errorMessage) throws IllegalConfigurationException {
        if (condition) {
            return;
        }
        throw new IllegalConfigurationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid configuration value for '", "' : ", " - ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, parameter, errorMessage})));
    }

    private String checkConfigParameter$default$4() {
        return "";
    }

    private void checkTempDirs(String[] tmpDirs) throws IOException {
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])tmpDirs).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<String, Object> x0$4) {
                String dir;
                Tuple2<String, Object> tuple2 = x0$4;
                if (tuple2 != null && (dir = (String)tuple2._1()) != null) {
                    String string = dir;
                    File file = new File(string);
                    if (file.exists()) {
                        if (file.isDirectory()) {
                            if (file.canWrite()) {
                                BoxedUnit boxedUnit;
                                if (TaskManager$.MODULE$.LOG().isInfoEnabled()) {
                                    long totalSpaceGb = file.getTotalSpace() >> 30;
                                    long usableSpaceGb = file.getUsableSpace() >> 30;
                                    double usablePercentage = (double)usableSpaceGb / (double)totalSpaceGb * (double)100;
                                    String path = file.getAbsolutePath();
                                    TaskManager$.MODULE$.LOG().info((Function0)new Serializable(this, totalSpaceGb, usableSpaceGb, usablePercentage, path){
                                        public static final long serialVersionUID = 0L;
                                        private final long totalSpaceGb$1;
                                        private final long usableSpaceGb$1;
                                        private final double usablePercentage$1;
                                        private final String path$1;

                                        public final String apply() {
                                            String arg$1 = this.path$1;
                                            Long arg$2 = BoxesRunTime.boxToLong((long)this.totalSpaceGb$1);
                                            Long arg$3 = BoxesRunTime.boxToLong((long)this.usableSpaceGb$1);
                                            double arg$4 = this.usablePercentage$1;
                                            return new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("Temporary file directory '%s': total %s GB, ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$1, arg$2}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("usable %s GB (%.2f%% usable)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$3, BoxesRunTime.boxToDouble((double)arg$4)}))).toString();
                                        }
                                        {
                                            this.totalSpaceGb$1 = totalSpaceGb$1;
                                            this.usableSpaceGb$1 = usableSpaceGb$1;
                                            this.usablePercentage$1 = usablePercentage$1;
                                            this.path$1 = path$1;
                                        }
                                    });
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                BoxedUnit boxedUnit2 = boxedUnit;
                                return;
                            }
                            throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Temporary file directory ", " is not writable."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file.getAbsolutePath()})));
                        }
                        throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Temporary file directory ", " is not a directory."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file.getAbsolutePath()})));
                    }
                    throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Temporary file directory ", " does not exist."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file.getAbsolutePath()})));
                }
                if (tuple2 != null) {
                    int id = tuple2._2$mcI$sp();
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Temporary file directory #", " is null."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id)})));
                }
                throw new MatchError(tuple2);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public MetricRegistry org$apache$flink$runtime$taskmanager$TaskManager$$createMetricsRegistry() {
        void var1_1;
        None$ none$;
        MetricRegistry metricRegistry = new MetricRegistry();
        metricRegistry.register("gc", (Metric)new GarbageCollectorMetricSet());
        metricRegistry.register("memory", (Metric)new MemoryUsageGaugeSet());
        metricRegistry.register("direct-memory", (Metric)new BufferPoolMetricSet(ManagementFactory.getPlatformMBeanServer()));
        metricRegistry.register("load", (Metric)new Gauge<Object>(){

            public double getValue() {
                return ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage();
            }
        });
        OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        try {
            none$ = Predef$.MODULE$.refArrayOps((Object[])Class.forName("com.sun.management.OperatingSystemMXBean").getMethods()).find((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Method x$8) {
                    String string = x$8.getName();
                    String string2 = "getProcessCpuLoad";
                    return !(string != null ? !string.equals(string2) : string2 != null);
                }
            });
        }
        catch (Throwable throwable) {
            this.LOG().warn((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Cannot access com.sun.management.OperatingSystemMXBean.getProcessCpuLoad() - CPU load metrics will not be available.";
                }
            });
            none$ = None$.MODULE$;
        }
        None$ fetchCPULoadMethod = none$;
        metricRegistry.register("cpuLoad", (Metric)new Gauge<Object>(osBean, (Option)fetchCPULoadMethod){
            public final OperatingSystemMXBean osBean$1;
            private final Option fetchCPULoadMethod$1;

            public double getValue() {
                double d;
                try {
                    d = BoxesRunTime.unboxToDouble((Object)this.fetchCPULoadMethod$1.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.3 $outer;

                        public final double apply(Method x$9) {
                            return BoxesRunTime.unboxToDouble((Object)x$9.invoke((Object)this.$outer.osBean$1, new Object[0]));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }).getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final double apply() {
                            return this.apply$mcD$sp();
                        }

                        public double apply$mcD$sp() {
                            return -1.0;
                        }
                    }));
                }
                catch (Throwable throwable) {
                    TaskManager$.MODULE$.LOG().warn((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Error retrieving CPU Load through OperatingSystemMXBean";
                        }
                    }, (Function0)new Serializable(this, throwable){
                        public static final long serialVersionUID = 0L;
                        private final Throwable t$12;

                        public final Throwable apply() {
                            return this.t$12;
                        }
                        {
                            this.t$12 = t$12;
                        }
                    });
                    d = -1.0;
                }
                return d;
            }
            {
                this.osBean$1 = osBean$1;
                this.fetchCPULoadMethod$1 = fetchCPULoadMethod$1;
            }
        });
        return var1_1;
    }

    private TaskManager$() {
        MODULE$ = this;
        this.LOG = Logger$.MODULE$.apply(TaskManager.class);
        this.STARTUP_FAILURE_RETURN_CODE = 1;
        this.RUNTIME_FAILURE_RETURN_CODE = 2;
        this.TASK_MANAGER_NAME = "taskmanager";
        this.MAX_STARTUP_CONNECT_TIME = 120000L;
        this.STARTUP_CONNECT_LOG_SUPPRESS = 10000L;
        this.INITIAL_REGISTRATION_TIMEOUT = new package.DurationInt(package$.MODULE$.DurationInt(500)).milliseconds();
        this.MAX_REGISTRATION_TIMEOUT = new package.DurationInt(package$.MODULE$.DurationInt(30)).seconds();
        this.DELAY_AFTER_REFUSED_REGISTRATION = new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds();
        this.HEARTBEAT_INTERVAL = new package.DurationInt(package$.MODULE$.DurationInt(5000)).milliseconds();
    }
}

