/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskmanager;

import java.util.Map;
import java.util.concurrent.Future;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.TaskInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.accumulators.AccumulatorRegistry;
import org.apache.flink.runtime.broadcast.BroadcastVariableManager;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.network.api.writer.ResultPartitionWriter;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.tasks.InputSplitProvider;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.messages.checkpoint.AcknowledgeCheckpoint;
import org.apache.flink.runtime.state.StateHandle;
import org.apache.flink.runtime.taskmanager.TaskManagerRuntimeInfo;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.apache.flink.util.SerializedValue;

public class RuntimeEnvironment
implements Environment {
    private final JobID jobId;
    private final JobVertexID jobVertexId;
    private final ExecutionAttemptID executionId;
    private final TaskInfo taskInfo;
    private final Configuration jobConfiguration;
    private final Configuration taskConfiguration;
    private final ClassLoader userCodeClassLoader;
    private final MemoryManager memManager;
    private final IOManager ioManager;
    private final BroadcastVariableManager bcVarManager;
    private final InputSplitProvider splitProvider;
    private final Map<String, Future<Path>> distCacheEntries;
    private final ResultPartitionWriter[] writers;
    private final InputGate[] inputGates;
    private final ActorGateway jobManager;
    private final AccumulatorRegistry accumulatorRegistry;
    private final TaskManagerRuntimeInfo taskManagerInfo;

    public RuntimeEnvironment(JobID jobId, JobVertexID jobVertexId, ExecutionAttemptID executionId, TaskInfo taskInfo, Configuration jobConfiguration, Configuration taskConfiguration, ClassLoader userCodeClassLoader, MemoryManager memManager, IOManager ioManager, BroadcastVariableManager bcVarManager, AccumulatorRegistry accumulatorRegistry, InputSplitProvider splitProvider, Map<String, Future<Path>> distCacheEntries, ResultPartitionWriter[] writers, InputGate[] inputGates, ActorGateway jobManager, TaskManagerRuntimeInfo taskManagerInfo) {
        this.jobId = Preconditions.checkNotNull(jobId);
        this.jobVertexId = Preconditions.checkNotNull(jobVertexId);
        this.executionId = Preconditions.checkNotNull(executionId);
        this.taskInfo = Preconditions.checkNotNull(taskInfo);
        this.jobConfiguration = Preconditions.checkNotNull(jobConfiguration);
        this.taskConfiguration = Preconditions.checkNotNull(taskConfiguration);
        this.userCodeClassLoader = Preconditions.checkNotNull(userCodeClassLoader);
        this.memManager = Preconditions.checkNotNull(memManager);
        this.ioManager = Preconditions.checkNotNull(ioManager);
        this.bcVarManager = Preconditions.checkNotNull(bcVarManager);
        this.accumulatorRegistry = Preconditions.checkNotNull(accumulatorRegistry);
        this.splitProvider = Preconditions.checkNotNull(splitProvider);
        this.distCacheEntries = Preconditions.checkNotNull(distCacheEntries);
        this.writers = Preconditions.checkNotNull(writers);
        this.inputGates = Preconditions.checkNotNull(inputGates);
        this.jobManager = Preconditions.checkNotNull(jobManager);
        this.taskManagerInfo = Preconditions.checkNotNull(taskManagerInfo);
    }

    @Override
    public JobID getJobID() {
        return this.jobId;
    }

    @Override
    public JobVertexID getJobVertexId() {
        return this.jobVertexId;
    }

    @Override
    public ExecutionAttemptID getExecutionId() {
        return this.executionId;
    }

    @Override
    public TaskInfo getTaskInfo() {
        return this.taskInfo;
    }

    @Override
    public Configuration getJobConfiguration() {
        return this.jobConfiguration;
    }

    @Override
    public Configuration getTaskConfiguration() {
        return this.taskConfiguration;
    }

    @Override
    public TaskManagerRuntimeInfo getTaskManagerInfo() {
        return this.taskManagerInfo;
    }

    @Override
    public ClassLoader getUserClassLoader() {
        return this.userCodeClassLoader;
    }

    @Override
    public MemoryManager getMemoryManager() {
        return this.memManager;
    }

    @Override
    public IOManager getIOManager() {
        return this.ioManager;
    }

    @Override
    public BroadcastVariableManager getBroadcastVariableManager() {
        return this.bcVarManager;
    }

    @Override
    public AccumulatorRegistry getAccumulatorRegistry() {
        return this.accumulatorRegistry;
    }

    @Override
    public InputSplitProvider getInputSplitProvider() {
        return this.splitProvider;
    }

    @Override
    public Map<String, Future<Path>> getDistributedCacheEntries() {
        return this.distCacheEntries;
    }

    @Override
    public ResultPartitionWriter getWriter(int index) {
        return this.writers[index];
    }

    @Override
    public ResultPartitionWriter[] getAllWriters() {
        return this.writers;
    }

    @Override
    public InputGate getInputGate(int index) {
        return this.inputGates[index];
    }

    @Override
    public InputGate[] getAllInputGates() {
        return this.inputGates;
    }

    @Override
    public void acknowledgeCheckpoint(long checkpointId) {
        this.acknowledgeCheckpoint(checkpointId, null);
    }

    @Override
    public void acknowledgeCheckpoint(long checkpointId, StateHandle<?> state) {
        long stateSize;
        SerializedValue serializedState;
        if (state == null) {
            serializedState = null;
            stateSize = 0L;
        } else {
            try {
                serializedState = new SerializedValue(state);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to serialize state handle during checkpoint confirmation", e);
            }
            try {
                stateSize = state.getStateSize();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to fetch state handle size", e);
            }
        }
        AcknowledgeCheckpoint message = new AcknowledgeCheckpoint(this.jobId, this.executionId, checkpointId, serializedState, stateSize);
        this.jobManager.tell(message);
    }
}

