/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.memory;

import java.io.IOException;
import java.io.Serializable;
import org.apache.flink.runtime.state.StateHandle;
import org.apache.flink.util.InstantiationUtil;

public class SerializedStateHandle<T extends Serializable>
implements StateHandle<T> {
    private static final long serialVersionUID = 4145685722538475769L;
    private final byte[] serializedData;

    public SerializedStateHandle(T value) throws IOException {
        this.serializedData = value == null ? null : InstantiationUtil.serializeObject(value);
    }

    public SerializedStateHandle(byte[] serializedData) {
        this.serializedData = serializedData;
    }

    @Override
    public T getState(ClassLoader classLoader) throws Exception {
        if (classLoader == null) {
            throw new NullPointerException();
        }
        return (T)(this.serializedData == null ? null : (Serializable)InstantiationUtil.deserializeObject((byte[])this.serializedData, (ClassLoader)classLoader));
    }

    public int getSizeOfSerializedState() {
        return this.serializedData.length;
    }

    @Override
    public void discardState() {
    }

    @Override
    public long getStateSize() {
        return this.serializedData.length;
    }
}

