/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.KvState;
import org.apache.flink.runtime.state.KvStateSnapshot;
import org.apache.flink.runtime.state.filesystem.AbstractFsState;
import org.apache.flink.runtime.state.filesystem.AbstractFsStateSnapshot;
import org.apache.flink.runtime.state.filesystem.FsStateBackend;

public class FsValueState<K, N, V>
extends AbstractFsState<K, N, V, ValueState<V>, ValueStateDescriptor<V>>
implements ValueState<V> {
    public FsValueState(FsStateBackend backend, TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer, ValueStateDescriptor<V> stateDesc) {
        super(backend, keySerializer, namespaceSerializer, stateDesc.getSerializer(), stateDesc);
    }

    public FsValueState(FsStateBackend backend, TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer, ValueStateDescriptor<V> stateDesc, HashMap<N, Map<K, V>> state) {
        super(backend, keySerializer, namespaceSerializer, stateDesc.getSerializer(), stateDesc, state);
    }

    public V value() {
        if (this.currentNSState == null) {
            this.currentNSState = (Map)this.state.get(this.currentNamespace);
        }
        if (this.currentNSState != null) {
            Object value = this.currentNSState.get(this.currentKey);
            return (V)(value != null ? value : ((ValueStateDescriptor)this.stateDesc).getDefaultValue());
        }
        return (V)((ValueStateDescriptor)this.stateDesc).getDefaultValue();
    }

    public void update(V value) {
        if (this.currentKey == null) {
            throw new RuntimeException("No key available.");
        }
        if (value == null) {
            this.clear();
            return;
        }
        if (this.currentNSState == null) {
            this.currentNSState = new HashMap();
            this.state.put(this.currentNamespace, this.currentNSState);
        }
        this.currentNSState.put(this.currentKey, value);
    }

    @Override
    public KvStateSnapshot<K, N, ValueState<V>, ValueStateDescriptor<V>, FsStateBackend> createHeapSnapshot(Path filePath) {
        return new Snapshot(this.getKeySerializer(), this.getNamespaceSerializer(), this.stateSerializer, (ValueStateDescriptor)this.stateDesc, filePath);
    }

    public static class Snapshot<K, N, V>
    extends AbstractFsStateSnapshot<K, N, V, ValueState<V>, ValueStateDescriptor<V>> {
        private static final long serialVersionUID = 1L;

        public Snapshot(TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer, TypeSerializer<V> stateSerializer, ValueStateDescriptor<V> stateDescs, Path filePath) {
            super(keySerializer, namespaceSerializer, stateSerializer, stateDescs, filePath);
        }

        @Override
        public KvState<K, N, ValueState<V>, ValueStateDescriptor<V>, FsStateBackend> createFsState(FsStateBackend backend, HashMap<N, Map<K, V>> stateMap) {
            return new FsValueState<K, N, V>(backend, this.keySerializer, this.namespaceSerializer, (ValueStateDescriptor)this.stateDesc, stateMap);
        }
    }
}

