/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.StateHandle;
import org.apache.flink.runtime.state.filesystem.AbstractFileStateHandle;
import org.apache.flink.util.InstantiationUtil;

public class FileSerializableStateHandle<T extends Serializable>
extends AbstractFileStateHandle
implements StateHandle<T> {
    private static final long serialVersionUID = -657631394290213622L;

    public FileSerializableStateHandle(Path filePath) {
        super(filePath);
    }

    @Override
    public T getState(ClassLoader classLoader) throws Exception {
        try (FSDataInputStream inStream = this.getFileSystem().open(this.getFilePath());){
            InstantiationUtil.ClassLoaderObjectInputStream ois = new InstantiationUtil.ClassLoaderObjectInputStream((InputStream)inStream, classLoader);
            Serializable serializable = (Serializable)ois.readObject();
            return (T)serializable;
        }
    }

    @Override
    public long getStateSize() throws IOException {
        return this.getFileSize();
    }
}

